/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Nov 2011)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoArray.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoEventCallback.h>

#define VerticalSpacing 15
#define HorizontalSpacing 12

SoFont* _font = 0;
SoText3* _title = 0;

// Define callback to switch used font on "F" key pressed event.
void changeFontCB( void* /*userData*/, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();
  if (SO_KEY_PRESS_EVENT(ev, F) )
  {
    static int index = 1;
    switch( index )
    {
    case 0: _font->name.setValue("OIV_Simplex_TGS" ); break;
    case 1: _font->name.setValue("OIV_Simplex_Roman" ); break;
    case 2: _font->name.setValue("OIV_Complex_Roman" ); break;
    case 3: _font->name.setValue("OIV_Duplex_Roman" ); break;
    case 4: _font->name.setValue("OIV_Triplex_Roman" ); break;
    case 5: _font->name.setValue("OIV_Simplex_Script" ); break;
    case 6: _font->name.setValue("OIV_Complex_Script" ); break;
    case 7: _font->name.setValue("OIV_Simplex_Greek" ); break;
    case 8: _font->name.setValue("OIV_Complex_Greek" ); break;
    case 9: _font->name.setValue("OIV_Gothic_German" ); break;
    case 10: _font->name.setValue("OIV_Gothic_Italian" ); break;
    case 11: _font->name.setValue("OIV_Gothic_English" ); break;
    case 12: _font->name.setValue("OIV_Complex_Cyrillic" ); break;
    case 13: _font->name.setValue("OIV_Upper_Case_Mathematics" ); break;
    case 14: _font->name.setValue("OIV_Lower_Case_Mathematics" ); break;
    case 15: _font->name.setValue("OIV_Music" ); break;
    case 16: _font->name.setValue("OIV_Meteorology" ); break;
    case 17: _font->name.setValue("OIV_Symbols" ); break;
    case 18: _font->name.setValue("OIV_Astrology" ); break;
    case 19: _font->name.setValue("OIV_Complex_Italic" ); break;
    case 20: _font->name.setValue("OIV_Triplex_Italic"); break;
    default:
      break;
    }
    index++;
    if (index == 21)
      index = 0;
    _title->string.setValue( _font->name.getValue() );
    eventCB->setHandled();
  }
}

// Main routine
int main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if(myWindow == NULL)
    exit(1);
  
  // initialize default stroke font.
  _font = new SoFont;
  _font->name.setValue("OIV_Simplex_TGS" );

  SoGroup *root = new SoGroup;
  root->ref();
  
  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback( SoKeyboardEvent::getClassTypeId(), changeFontCB, 0);
  root->addChild(myCallbackNode);

  SoBaseColor* color = new SoBaseColor();
  color->rgb.setValue(0,0,0);
  root->addChild(color);

  { // Draw the title (the font name)
    SoSeparator* titleSep = new SoSeparator();
    root->addChild(titleSep);
    SoTranslation* translation = new SoTranslation;
    translation->translation.setValue(0, VerticalSpacing * 2, 0 );
    titleSep->addChild(translation);
    _title = new SoText3;
    _title->string.setValue( _font->name.getValue() );
    titleSep->addChild(_title);
  }

  { // Draw the grid.
    SoSeparator* cubeArraySep = new SoSeparator();
    root->addChild(cubeArraySep);
    SoTranslation* translation = new SoTranslation;
    translation->translation.setValue(HorizontalSpacing / 4, VerticalSpacing / 5, 0 );
    cubeArraySep->addChild(translation);
    SoArray* nodesArray = new SoArray();
    SoDrawStyle* style = new SoDrawStyle();
    style->style = SoDrawStyle::LINES;
    cubeArraySep->addChild(style);
    SoCube* cube = new SoCube();
    cube->width = HorizontalSpacing;
    cube->height = VerticalSpacing;
    nodesArray->addChild( cube );
    nodesArray->numElements1 = 8;
    nodesArray->numElements2 = 12;
    nodesArray->separation1.setValue( HorizontalSpacing, 0, 0);
    nodesArray->separation2.setValue( 0, -VerticalSpacing, 0);
    cubeArraySep->addChild(nodesArray);
  }

  SoTranslation* translation2 = new SoTranslation;
  translation2->translation.setValue(HorizontalSpacing, 0, 0 );

  { // Render Stroke glyphs
    SoSeparator* sep = new SoSeparator();
    root->addChild(sep);
    sep->addChild(_font);
    for ( int i = 32; i <= 127; i++ ) // Acceptable values are in the range [32..127]
    {
      char msg[2] = { (char)i, '\0' };
      SoText3* oivText = new SoText3;
      oivText->string.setValue(msg);
      sep->addChild(oivText);
      sep->addChild(translation2);
      if ( (i-7) % 8 == 0 )
      {
        SoTranslation* translation3 = new SoTranslation;
        translation3->translation.setValue(-HorizontalSpacing * 8, -VerticalSpacing, 0 );
        sep->addChild(translation3);
      }
    }
  }


  { // Draw the stroke glyph index
    SoSeparator* sep = new SoSeparator();
    root->addChild(sep);
    SoTranslation* translation = new SoTranslation;
    translation->translation.setValue(HorizontalSpacing / 3.0f, -VerticalSpacing / 4.5f, 0 );
    sep->addChild(translation);
    SoFont *font = new SoFont;
    font->size = VerticalSpacing / 5;
    sep->addChild(font);
    for ( int i = 32; i < 128; i++ ) // Acceptable values are in the range [32..127]
    {
      SoText3* oivText = new SoText3;
      oivText->string.setValue( SbString(i) );
      sep->addChild(oivText);
      sep->addChild(translation2);

      if ( (i-7) % 8 == 0 )
      {
        SoTranslation* translation3 = new SoTranslation;
        translation3->translation.setValue(-HorizontalSpacing * 8, -VerticalSpacing, 0 );
        sep->addChild(translation3);
      }
    }
  }


  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSize( SbVec2s(800, 600) );
  myViewer->setBackgroundColor( SbColor( 1,1,1));
  myViewer->setSceneGraph(root);
  myViewer->setTitle("3D Text");
  
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();
  
  return 0;
}


