#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <DialogViz/SoDialogVizAll.h>
#include <Inventor/nodes/SoAnnoText3.h>
#include <Inventor/nodes/SoAnnoText3Property.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoComplexity.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoLinearProfile.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoProfileCoordinate2.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/nodes/SoTextProperty.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTranslation.h>

#include <Inventor/helpers/SbFileHelper.h>
#include <Inventor/SoPickedPoint.h>
#include <Inventor/actions/SoRayPickAction.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoMouseButtonEvent.h>

#include <limits.h>

SoXtExaminerViewer* viewer = NULL;
SoTopLevelDialog* mainWindow = NULL;
SoSeparator* root = NULL;
SoDialogComboBox* fontList = NULL;
SoRowDialog* rightCol = NULL;
SoDialogComboBox* type = NULL;
SoDialogComboBox* orientation = NULL;
SoDialogComboBox* alignH = NULL;
SoDialogComboBox* alignV = NULL;
SoDialogComboBox* style = NULL;
SoDialogCheckBox* profile = NULL;
SoDialogCheckBox* texture = NULL;
SoDialogCheckBox* kerning = NULL;
SoDialogRealSlider* fontSize = NULL;
SoDialogRealSlider* quality = NULL;
SoDialogRealSlider* color = NULL;
SoDialogRealSlider* margin = NULL;
SoDialogRealSlider* spacing = NULL;
SoDialogEditText* customText = NULL;
SoDialogCheckBox* customTextEnable = NULL;
SoDialogCheckBox* optionU = NULL;
SoDialogCheckBox* optionS = NULL;
SoDialogCheckBox* optionDS = NULL;
SoDialogCheckBox* optionBF = NULL;
SoDialogCheckBox* optionBFL = NULL;
SoDialogCheckBox* optionOverline = NULL;
SoDialogCheckBox* optionUTransp = NULL;
SoDialogCheckBox* optionSTransp = NULL;
SoDialogCheckBox* optionDSTransp = NULL;
SoDialogCheckBox* optionBFTransp = NULL;
SoDialogCheckBox* optionBFLTransp = NULL;
SoDialogCheckBox* optionOverlineTransp = NULL;
SoDialogRealSlider* optionUColor = NULL;
SoDialogRealSlider* optionSColor = NULL;
SoDialogRealSlider* optionDSColor = NULL;
SoDialogRealSlider* optionBFColor = NULL;
SoDialogRealSlider* optionBFLColor = NULL;
SoDialogRealSlider* optionOverlineColor = NULL;
SoDialogEditText* texQualityMin = NULL;
SoDialogEditText* texQualityMax = NULL;
SoDialogRealSlider* texAliasFactor = NULL;
SoDialogRealSlider* texQuality = NULL;

SoAnnoText3* annotext = NULL;
SoComplexity* complexity = NULL;
SoDrawStyle* drawStyle = NULL;
SoFont* font = NULL;
SoSwitch* profileSwitch = NULL;
SoSwitch* textureSwitch = NULL;
SoSwitch* switchText = NULL;
SoText2* text2 = NULL;
SoText3* text3 = NULL;
SoTextProperty* textProperty = NULL;
SoSphere* sphere = NULL;
SoMaterial* textColor[5];

bool strokeFontEnabled = false;
int strokeFontSelection = 0;
int stdFontSelection = 0;
SbString* allFonts;
int numFonts;

#if defined(WIN32) 
#  define FROM2TO4(a,b) a, b
#else
#  define FROM2TO4(a,b) a, b, 0, 0
#endif

const unsigned char arabic[] = {
  FROM2TO4(0x2a, 0x06),
  FROM2TO4(0x31, 0x06),
  FROM2TO4(0x2d, 0x06),
  FROM2TO4(0x4a, 0x06),
  FROM2TO4(0x28, 0x06),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x28, 0x00),
  FROM2TO4(0x41, 0x00),
  FROM2TO4(0x72, 0x00), 
  FROM2TO4(0x61, 0x00),
  FROM2TO4(0x62, 0x00),
  FROM2TO4(0x69, 0x00),
  FROM2TO4(0x63, 0x00),
  FROM2TO4(0x29, 0x00),
  FROM2TO4(0x00, 0x00)
};

const unsigned char traditionalChinese[] = {
  FROM2TO4(0x61, 0x6b),
  FROM2TO4(0xce, 0x8f),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x28, 0x00),
  FROM2TO4(0x54, 0x00),
  FROM2TO4(0x72, 0x00), 
  FROM2TO4(0x61, 0x00),
  FROM2TO4(0x64, 0x00),
  FROM2TO4(0x69, 0x00),
  FROM2TO4(0x74, 0x00),
  FROM2TO4(0x69, 0x00),
  FROM2TO4(0x6f, 0x00),
  FROM2TO4(0x6e, 0x00),
  FROM2TO4(0x61, 0x00),
  FROM2TO4(0x6c, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x43, 0x00), 
  FROM2TO4(0x68, 0x00),
  FROM2TO4(0x69, 0x00),
  FROM2TO4(0x6e, 0x00),
  FROM2TO4(0x65, 0x00),
  FROM2TO4(0x73, 0x00),
  FROM2TO4(0x65, 0x00),
  FROM2TO4(0x29, 0x00),
  FROM2TO4(0x00, 0x00),
  FROM2TO4(0x00, 0x00)
};

const unsigned char korean[] = {
  FROM2TO4(0x58, 0xd6),
  FROM2TO4(0x01, 0xc6),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x28, 0x00), 
  FROM2TO4(0x4b, 0x00),
  FROM2TO4(0x6f, 0x00),
  FROM2TO4(0x72, 0x00),
  FROM2TO4(0x65, 0x00),
  FROM2TO4(0x61, 0x00),
  FROM2TO4(0x6e, 0x00),
  FROM2TO4(0x29, 0x00),
  FROM2TO4(0x00, 0x00)
};

const unsigned char russian[] = {
  FROM2TO4(0x14, 0x04),
  FROM2TO4(0x3e, 0x04),
  FROM2TO4(0x31, 0x04),
  FROM2TO4(0x40, 0x04),
  FROM2TO4(0x3e, 0x04),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x3f, 0x04),
  FROM2TO4(0x3e, 0x04),
  FROM2TO4(0x36, 0x04),
  FROM2TO4(0x30, 0x04),
  FROM2TO4(0x3b, 0x04),
  FROM2TO4(0x3e, 0x04),
  FROM2TO4(0x32, 0x04),
  FROM2TO4(0x30, 0x04),
  FROM2TO4(0x42, 0x04),
  FROM2TO4(0x4c, 0x04),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x28, 0x00),
  FROM2TO4(0x52, 0x00),
  FROM2TO4(0x75, 0x00),
  FROM2TO4(0x73, 0x00),
  FROM2TO4(0x73, 0x00),
  FROM2TO4(0x69, 0x00),
  FROM2TO4(0x61, 0x00),
  FROM2TO4(0x6e, 0x00),
  FROM2TO4(0x29, 0x00),
  FROM2TO4(0x00, 0x00)
};

const unsigned char swedish[] = {
  FROM2TO4(0x56, 0x00),
  FROM2TO4(0xe4, 0x00),
  FROM2TO4(0x6c, 0x00),
  FROM2TO4(0x6b, 0x00),
  FROM2TO4(0x6f, 0x00),
  FROM2TO4(0x6d, 0x00),
  FROM2TO4(0x6d, 0x00),
  FROM2TO4(0x65, 0x00),
  FROM2TO4(0x74, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x28, 0x00),
  FROM2TO4(0x53, 0x00),
  FROM2TO4(0x77, 0x00),
  FROM2TO4(0x65, 0x00),
  FROM2TO4(0x64, 0x00),
  FROM2TO4(0x69, 0x00),
  FROM2TO4(0x73, 0x00),
  FROM2TO4(0x68, 0x00),
  FROM2TO4(0x29, 0x00),
  FROM2TO4(0x00, 0x00)
};

const unsigned char greek[] = {
  FROM2TO4(0x9a, 0x03),
  FROM2TO4(0xb1, 0x03),
  FROM2TO4(0xbb, 0x03),
  FROM2TO4(0xc9, 0x03),
  FROM2TO4(0xc3, 0x03),
  FROM2TO4(0xcc, 0x03),
  FROM2TO4(0xc1, 0x03),
  FROM2TO4(0xb9, 0x03),
  FROM2TO4(0xc3, 0x03),
  FROM2TO4(0xbc, 0x03),
  FROM2TO4(0xb1, 0x03),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x20, 0x00),
  FROM2TO4(0x28, 0x00),
  FROM2TO4(0x47, 0x00),
  FROM2TO4(0x72, 0x00),
  FROM2TO4(0x65, 0x00),
  FROM2TO4(0x65, 0x00),
  FROM2TO4(0x6b, 0x00),
  FROM2TO4(0x29, 0x00),
  FROM2TO4(0x00, 0x00)
};


SbBool
writePickedPath(SoNode *root, const SbViewportRegion &viewport, const SbVec2s &cursorPosition)
{
  SoRayPickAction myPickAction(viewport);
  
  // Set an 8-pixel wide region around the pixel
  myPickAction.setPoint(cursorPosition);
  myPickAction.setRadius(8.0);
  
  // Start a pick traversal
  myPickAction.apply(root);
  const SoPickedPoint *myPickedPoint = myPickAction.getPickedPoint();
  if (myPickedPoint == NULL)
    return FALSE;

  // Write out the path to the picked object
  SoWriteAction myWriteAction;  
  myWriteAction.apply(myPickedPoint->getPath());
    
  return TRUE;
}

// CODE FOR The Inventor Mentor ENDS HERE
///////////////////////////////////////////////////////////////

// This routine is called for every mouse button event.
void
myMousePressCB(void *userData, SoEventCallback *eventCB)
{
  SoSeparator *root = (SoSeparator *) userData;
  const SoEvent *event = eventCB->getEvent();
  
  // Check for mouse button being pressed
  if (SO_MOUSE_PRESS_EVENT(event, ANY))
  {
    const SbViewportRegion &myRegion = eventCB->getAction()->getViewportRegion();
    writePickedPath(root, myRegion, event->getPosition(myRegion));
    eventCB->setHandled();
  }
}


/*************************************************************************/
void
setText()
// Description :
//-------------------------------------------------------------------------
{
  if (customTextEnable && customTextEnable->state.getValue() == TRUE)
  {
    text2->string.deleteValues(0);
    text3->string.deleteValues(0);
    annotext->string.deleteValues(0);

    SbStringList list;
    
#ifdef WIN32    
    list = SbStringList::split( customText->editText.getValue(), "\r\n" );
#else 
    list = SbStringList::split( customText->editText.getValue(), "\n" );
#endif
    int lineCount = list.getLength();

    for (int line = 0; line <lineCount; line++)
    {
      text2->string.set1Value( line, *list[ line ]);
      text3->string.set1Value( line, *list[ line ]);
      annotext->string.set1Value( line, *list[ line ]);

      delete list[ line ];
    }
  }
  else
  {
    int i=0;

    SbString str ("Welcome (English)");
    text2->string.set1Value( i, str );
    text3->string.set1Value( i, str );
    annotext->string.set1Value( i, str );

    i++;
    str = "Bienvenue (French)";
    text2->string.set1Value( i, str );
    text3->string.set1Value( i, str );
    annotext->string.set1Value( i, str );
    
    i++;
    str = (SO_WCHAR_T*)arabic;

    text2->string.set1Value( i, str );
    text3->string.set1Value( i, str );
    annotext->string.set1Value( i, str );

    i++;
    str = (SO_WCHAR_T*)traditionalChinese;
    text2->string.set1Value( i, str );
    text3->string.set1Value( i, str );
    annotext->string.set1Value( i, str );

    i++;
    str = (SO_WCHAR_T*)korean;
    text2->string.set1Value( i, str );
    text3->string.set1Value( i, str );
    annotext->string.set1Value( i, str );

    i++;
    str = (SO_WCHAR_T*)russian;
    text2->string.set1Value( i, str );
    text3->string.set1Value( i, str );
    annotext->string.set1Value( i, str );

    i++;
    str = (SO_WCHAR_T*)swedish;
    text2->string.set1Value( i, str );
    text3->string.set1Value( i, str );
    annotext->string.set1Value( i, str );

    i++;
    str = (SO_WCHAR_T*)greek;
    text2->string.set1Value( i, str );
    text3->string.set1Value( i, str );
    annotext->string.set1Value( i, str );
  }
}

/*************************************************************************/
SoSeparator*
buildSceneGraph()
// Description :
//    Build the Open Inventor scene graph.
//-------------------------------------------------------------------------
{
  root = new SoSeparator;
  root->ref();

  SoSeparator* sphereSep = new SoSeparator;

  SoTranslation* transl1 = new SoTranslation;
  transl1->translation.setValue(0, 0, -10);

  SoBaseColor* color = new SoBaseColor;
  color->rgb.setValue(1,0,0);
  sphere = new SoSphere;
  sphere->radius = 2;

  font = new SoFont;
  font->name = "Arial Unicode MS";
  font->setNumFontCaches(10);
  font->size = 18;

  drawStyle = new SoDrawStyle;
  complexity = new SoComplexity;
  complexity->value = 0.7f;
  textProperty = new SoTextProperty;

  switchText = new SoSwitch;

  SoSeparator* text2Sep = new SoSeparator;
  SoSeparator* text3Sep = new SoSeparator;
  SoSeparator* annotext1Sep = new SoSeparator;
  SoSeparator* annotext2Sep = new SoSeparator;
  SoSeparator* strokeSep = new SoSeparator;

  for (int k=0; k<5; k++)
    textColor[k] = new SoMaterial();

  text2 = new SoText2;
  text2->justification = SoText2::INHERITED;
  text3 = new SoText3;
  text3->justification = SoText3::INHERITED;
  annotext = new SoAnnoText3;
  annotext->justification = SoAnnoText3::INHERITED;
  setText();

  profileSwitch = new SoSwitch;
  textureSwitch = new SoSwitch;

  SoAnnoText3Property* annoProp1 = new SoAnnoText3Property;
  annoProp1->fontSizeHint = SoAnnoText3Property::ANNOTATION;
  annoProp1->renderPrintType = SoAnnoText3Property::RENDER2D_PRINT_RASTER;
  SoAnnoText3Property* annoProp2 = new SoAnnoText3Property;
  annoProp2->fontSizeHint = SoAnnoText3Property::FIT_VECTOR_TEXT;
  annoProp2->renderPrintType = SoAnnoText3Property::RENDER2D_PRINT_RASTER;

  // Specify a beveled cross-section for the text
  SoProfileCoordinate2* myProfileCoords = new SoProfileCoordinate2;
  SbVec2f coords[4];
  coords[0].setValue(0.00f, 0.00f);
  coords[1].setValue(0.25f, 0.25f);
  coords[2].setValue(1.25f, 0.25f);
  coords[3].setValue(1.50f, 0.00f);
  myProfileCoords->point.setValues(0, 4, coords);

  SoLinearProfile* myLinearProfile = new SoLinearProfile;
  int32_t	index[4] ;
  index[0] = 0;
  index[1] = 1;
  index[2] = 2;
  index[3] = 3;
  myLinearProfile->index.setValues(0, 4, index);

  SoTexture2* myTexture2 = new SoTexture2;
  myTexture2->filename = SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/TextExtensions/TextProperties/earth.jpg");

  root->addChild(sphereSep);
    sphereSep->addChild(transl1);
    sphereSep->addChild(color);
    sphereSep->addChild(sphere);
  root->addChild(font);
  root->addChild(drawStyle);
  root->addChild(complexity);
  root->addChild(textProperty);
  root->addChild(switchText);
    switchText->addChild(text2Sep);
      text2Sep->addChild(textColor[0]);
      text2Sep->addChild(text2);
    switchText->addChild(text3Sep);
      text3Sep->addChild(textColor[1]);
      text3Sep->addChild(textureSwitch);
        textureSwitch->addChild(myTexture2);
      text3Sep->addChild(profileSwitch);
        profileSwitch->addChild(myProfileCoords);
        profileSwitch->addChild(myLinearProfile);
      text3Sep->addChild(text3);
    switchText->addChild(annotext1Sep);
      annotext1Sep->addChild(textColor[2]);
      annotext1Sep->addChild(annoProp1);
      annotext1Sep->addChild(annotext);
    switchText->addChild(annotext2Sep);
      annotext2Sep->addChild(textColor[3]);
      annotext2Sep->addChild(annoProp2);
      annotext2Sep->addChild(annotext);
    switchText->addChild(strokeSep);
      strokeSep->addChild(textColor[4]);
      strokeSep->addChild(text3);
    switchText->whichChild = 1;

  return root;
}

/*************************************************************************/
void
fillFontList(bool strokeFont)
// Description :
//-------------------------------------------------------------------------
{
  int i = 0;
  fontList->items.enableNotify(false);
  if (!strokeFont) {
    if (strokeFontEnabled) {
      fontList->items.deleteValues(0);
      for ( i = 0; i< numFonts; i++)
        fontList->addItem(allFonts[i]);
    }
    font->name = fontList->items[stdFontSelection];
    setText();
  }
  else {
    if (!strokeFontEnabled) {
      fontList->items.deleteValues(0);
      fontList->items.set1Value(i++, "TGS_Simplex_TGS");
      fontList->items.set1Value(i++, "TGS_Simplex_Roman");
      fontList->items.set1Value(i++, "TGS_Complex_Roman");
      fontList->items.set1Value(i++, "TGS_Duplex_Roman");
      fontList->items.set1Value(i++, "TGS_Triplex_Roman");
      fontList->items.set1Value(i++, "TGS_Simplex_Script");
      fontList->items.set1Value(i++, "TGS_Complex_Script"); 
      fontList->items.set1Value(i++, "TGS_Simplex_Greek");
      fontList->items.set1Value(i++, "TGS_Complex_Greek");
      fontList->items.set1Value(i++, "TGS_Gothic_German");
      fontList->items.set1Value(i++, "TGS_Gothic_Italian");
      fontList->items.set1Value(i++, "TGS_Gothic_English");
      fontList->items.set1Value(i++, "TGS_Complex_Cyrillic");
      fontList->items.set1Value(i++, "TGS_Upper_Case_Mathematics");
      fontList->items.set1Value(i++, "TGS_Lower_Case_Mathematics");
      fontList->items.set1Value(i++, "TGS_Music");
      fontList->items.set1Value(i++, "TGS_Meteorology");
      fontList->items.set1Value(i++, "TGS_Symbols");
      fontList->items.set1Value(i++, "TGS_Astrology");
      fontList->items.set1Value(i++, "TGS_Complex_Italic");
      fontList->items.set1Value(i++, "TGS_Triplex_Italic");

      font->name = fontList->items[strokeFontSelection];
      text3->string.deleteValues(0);
      SbString strokeString = "Welcome";
      text3->string.set1Value(0, strokeString );
      strokeString = "Bienvenue";
      text3->string.set1Value(1, strokeString );
    }
  }
  strokeFontEnabled = strokeFont;
  fontList->items.enableNotify(true);
  fontList->items.touch();
}

/*************************************************************************/
class ChooseTypeAud : public SoDialogChoiceAuditor {
  void dialogChoice(SoDialogChoice* cpt) {
    int selected = cpt->selectedItem.getValue();
    alignH->enable = TRUE;
    alignV->enable = TRUE;
    orientation->enable = TRUE;
    kerning->enable = TRUE;
    quality->enable = TRUE;
    sphere->radius = 10;
    float h,s,v;
    textColor[selected]->diffuseColor[0].getHSVValue(h, s, v);
    color->value.setValue(h);
    if (style->items.getNum() == 1)
      style->addItem("TEXTURE");
    if (style->items.getNum() == 2)
      style->addItem("LINES");
    if (cpt->items[selected] == "2D")
    {
      fillFontList(false);
      profile->enable = FALSE;
      texture->enable = FALSE;
      style->removeItem(2);
      style->enable = TRUE;
      viewer->viewAll();
      sphere->radius = 1;
    }
    else if (cpt->items[selected] == "3D")
    {
      fillFontList(false);
      profile->enable = TRUE;
      texture->enable = TRUE;
      style->enable = TRUE;
      viewer->viewAll();
    }
    else if (cpt->items[selected] == "Annotation")
    {
      fillFontList(false);
      profile->enable = FALSE;
      texture->enable = FALSE;
      style->enable = TRUE;
      viewer->viewAll();
    }
    else if (cpt->items[selected] == "Annotation (FIT)")
    {
      fillFontList(false);
      profile->enable = FALSE;
      texture->enable = FALSE;
      style->enable = TRUE;
      viewer->viewAll();
    }
    else if (cpt->items[selected] == "Stroke font")
    {
      fillFontList(true);
      profile->enable = FALSE;
      texture->enable = FALSE;
      style->enable = FALSE;
      alignH->enable = FALSE;
      alignV->enable = FALSE;
      orientation->enable = FALSE;
      kerning->enable = FALSE;
      quality->enable = FALSE;
      viewer->viewAll();
    }
  }
};

/*************************************************************************/
class ChooseStyleAud : public SoDialogChoiceAuditor {
  void dialogChoice(SoDialogChoice* cpt) {
    int selected = cpt->selectedItem.getValue();
    if (cpt->items[selected] == "POLYGON") {
      font->renderStyle = SoFont::POLYGON;
      drawStyle->style = SoDrawStyle::FILLED;
      viewer->setDrawStyle (SoXtViewer::STILL, SoXtViewer::VIEW_AS_IS);
      if (type->items[type->selectedItem.getValue()] == "2D")
      {
        texture->enable = FALSE;
        profile->enable = FALSE;
      }
      else
      {
        texture->enable = TRUE;
        profile->enable = TRUE;
      }
      texAliasFactor->enable = FALSE;
      texQuality->enable = FALSE;
      texQualityMin->enable = FALSE;
      texQualityMax->enable = FALSE;
    }
    else if (cpt->items[selected] == "TEXTURE") {
      font->renderStyle = SoFont::TEXTURE;
      drawStyle->style = SoDrawStyle::FILLED;
      viewer->setDrawStyle (SoXtViewer::STILL, SoXtViewer::VIEW_AS_IS);
      texture->enable = FALSE;
      profile->enable = FALSE;
      texAliasFactor->enable = TRUE;
      texQuality->enable = TRUE;
      texQualityMin->enable = TRUE;
      texQualityMax->enable = TRUE;
    }
    else if (cpt->items[selected] == "LINES") {
      font->renderStyle = SoFont::POLYGON_AND_OUTLINE;
      drawStyle->style = SoDrawStyle::LINES;
      viewer->setDrawStyle (SoXtViewer::STILL, SoXtViewer::VIEW_LINE);
      texture->enable = TRUE;
      profile->enable = TRUE;
      texAliasFactor->enable = FALSE;
      texQuality->enable = FALSE;
      texQualityMin->enable = FALSE;
      texQualityMax->enable = FALSE;
    }
  }
};

/*************************************************************************/
class ChooseOptionColorAud : public SoDialogRealSliderAuditor
{
public:
  static void changeColors()
  {
    if (optionUTransp->state.getValue())
      textProperty->styleColors.set1HSVAValue( SoTextProperty::UNDERLINE_COLOR, optionUColor->value.getValue(), 1, 1, 0.5);
    else
      textProperty->styleColors.set1HSVAValue( SoTextProperty::UNDERLINE_COLOR, optionUColor->value.getValue(), 1, 1, 1.0);

    if (optionSTransp->state.getValue())
      textProperty->styleColors.set1HSVAValue( SoTextProperty::STRIKETHROUGH_COLOR, optionSColor->value.getValue(), 1, 1, 0.5);
    else
      textProperty->styleColors.set1HSVAValue( SoTextProperty::STRIKETHROUGH_COLOR, optionSColor->value.getValue(), 1, 1, 1.0);

    if (optionDSTransp->state.getValue())
      textProperty->styleColors.set1HSVAValue( SoTextProperty::DOUBLE_STRIKETHROUGH_COLOR, optionDSColor->value.getValue(), 1, 1, 0.5);
    else
      textProperty->styleColors.set1HSVAValue( SoTextProperty::DOUBLE_STRIKETHROUGH_COLOR, optionDSColor->value.getValue(), 1, 1, 1.0);

    if (optionBFTransp->state.getValue())
      textProperty->styleColors.set1HSVAValue( SoTextProperty::BACK_FRAME_COLOR, optionBFColor->value.getValue(), 1, 1, 0.5);
    else
      textProperty->styleColors.set1HSVAValue( SoTextProperty::BACK_FRAME_COLOR, optionBFColor->value.getValue(), 1, 1, 1.0);

    if (optionBFLTransp->state.getValue())
      textProperty->styleColors.set1HSVAValue( SoTextProperty::BACK_FRAME_LINE_COLOR, optionBFLColor->value.getValue(), 1, 1, 0.5);
    else
      textProperty->styleColors.set1HSVAValue( SoTextProperty::BACK_FRAME_LINE_COLOR, optionBFLColor->value.getValue(), 1, 1, 1.0);

    if (optionOverlineTransp->state.getValue())
      textProperty->styleColors.set1HSVAValue( SoTextProperty::OVERLINE_COLOR, optionOverlineColor->value.getValue(), 1, 1, 0.5);
    else
      textProperty->styleColors.set1HSVAValue( SoTextProperty::OVERLINE_COLOR, optionOverlineColor->value.getValue(), 1, 1, 1.0);
  }

  void dialogRealSlider(SoDialogRealSlider*)
  {
    changeColors();
  }
};


/*************************************************************************/
class ChooseOptionAud : public SoDialogCheckBoxAuditor
{
  void dialogCheckBox(SoDialogCheckBox*)
  {
    textProperty->style = ( optionU->state.getValue() ? SoTextProperty::UNDERLINE : 0 )
    | ( optionS->state.getValue() ? SoTextProperty::STRIKETHROUGH : 0 )
    | ( optionDS->state.getValue() ? SoTextProperty::DOUBLE_STRIKETHROUGH : 0 )
    | ( optionBF->state.getValue() ? SoTextProperty::BACK_FRAME : 0 )
    | ( optionBFL->state.getValue() ? SoTextProperty::BACK_FRAME_LINE : 0 )
    | ( optionOverline->state.getValue() ? SoTextProperty::OVERLINE : 0 );
    ChooseOptionColorAud::changeColors();
  }
};

/*************************************************************************/
class ChooseTexQualMinMaxAud : public SoDialogEditTextAuditor
{
  void dialogEditText(SoDialogEditText*)
  {
    textProperty->textureQualityRange.setValue(
      SbVec2i32( atoi(texQualityMin->editText.getValue().toLatin1()),
                 atoi(texQualityMax->editText.getValue().toLatin1())) );
  }
};

/*************************************************************************/
class SetProfileAud : public SoDialogCheckBoxAuditor {
  void dialogCheckBox(SoDialogCheckBox* cpt) {
    if (cpt->state.getValue()) {
      text3->parts = SoText3::ALL;
      profileSwitch->whichChild = SO_SWITCH_ALL;
    }
    else {
      text3->parts = SoText3::FRONT;
      profileSwitch->whichChild = SO_SWITCH_NONE;
    }
  }
};

/*************************************************************************/
class SetTextureAud : public SoDialogCheckBoxAuditor {
  void dialogCheckBox(SoDialogCheckBox* cpt) {
    if (cpt->state.getValue()) {
      textureSwitch->whichChild = SO_SWITCH_ALL;
    }
    else {
      textureSwitch->whichChild = SO_SWITCH_NONE;
    }
  }
};

/*************************************************************************/
class SetColorAud : public SoDialogRealSliderAuditor {
  void dialogRealSlider(SoDialogRealSlider* cpt) {
    textColor[type->selectedItem.getValue()]->diffuseColor.set1HSVValue(0, cpt->value.getValue(), 1, 1);
  }
};

/*************************************************************************/
class SetCustomTextAud : public SoDialogEditTextAuditor {
  void dialogEditText(SoDialogEditText*) {
    setText();
  }
};

/*************************************************************************/
class SetCustomTextEnableAud : public SoDialogCheckBoxAuditor {
  void dialogCheckBox(SoDialogCheckBox*) {
    setText();
  }
};

/*************************************************************************/
class ChooseFontAud : public SoDialogChoiceAuditor {
  void dialogChoice(SoDialogChoice* cpt) {
    if (strokeFontEnabled)
    { // Stroke Font case
      strokeFontSelection = cpt->selectedItem.getValue();
      font->name = cpt->items[strokeFontSelection];
    }
    else
    {
      stdFontSelection = cpt->selectedItem.getValue();
      font->name = cpt->items[stdFontSelection];
    }
  }
};

/*************************************************************************/
class ChooseOrientationAud : public SoDialogChoiceAuditor {
  void dialogChoice(SoDialogChoice* cpt) {
    SbString selected = cpt->items[cpt->selectedItem.getValue()];
    if (selected == SbString("LEFT_TO_RIGHT"))
      textProperty->orientation = SoTextProperty::LEFT_TO_RIGHT;
    else if (selected == SbString("RIGHT_TO_LEFT"))
      textProperty->orientation = SoTextProperty::RIGHT_TO_LEFT;
    else if (selected == SbString("TOP_TO_BOTTOM"))
      textProperty->orientation = SoTextProperty::TOP_TO_BOTTOM;
    else if (selected == SbString("BOTTOM_TO_TOP"))
      textProperty->orientation = SoTextProperty::BOTTOM_TO_TOP;
  }
};

/*************************************************************************/
class ChooseAlignmentHAud : public SoDialogChoiceAuditor {
  void dialogChoice(SoDialogChoice* cpt) {
    SbString selected = cpt->items[cpt->selectedItem.getValue()];
    if (selected == SbString("LEFT"))
      textProperty->alignmentH = SoTextProperty::LEFT;
    else if (selected == SbString("RIGHT"))
      textProperty->alignmentH = SoTextProperty::RIGHT;
    else if (selected == SbString("CENTER"))
      textProperty->alignmentH = SoTextProperty::CENTER;
  }
};

/*************************************************************************/
class ChooseAlignmentVAud : public SoDialogChoiceAuditor {
  void dialogChoice(SoDialogChoice* cpt) {
    SbString selected = cpt->items[cpt->selectedItem.getValue()];
    if (selected == "TOP")
      textProperty->alignmentV = SoTextProperty::TOP;
    else if (selected == "HALF")
      textProperty->alignmentV = SoTextProperty::HALF;
    else if (selected == "BASE")
      textProperty->alignmentV = SoTextProperty::BASE;
    else if (selected == "BOTTOM")
      textProperty->alignmentV = SoTextProperty::BOTTOM;
  }
};

/*************************************************************************/
void
launchDialogVizComponents()
// Description :
//    Retrieve all needed componenets for this example.
//-------------------------------------------------------------------------
{
  rightCol = (SoRowDialog*)mainWindow->searchForAuditorId("rightCol");
  fontList = (SoDialogComboBox*)mainWindow->searchForAuditorId("fontList");
  numFonts = SoFont::getAvailableFonts(allFonts);
  SbVec2i32 maxSize(0,0);
  for( int i = 0; i< numFonts; i++) {
    SbVec2i32 size = SoDialogViz::getLabelPixelSize(allFonts[i], fontList);
    if (size[0] > maxSize[0])
      maxSize[0] = size[0];
    fontList->addItem(allFonts[i]);
    if (!stdFontSelection && strstr(allFonts[i].getString(), "Arial Unicode MS") != NULL)
      stdFontSelection = fontList->items.getNum() - 1;
  }
  fontList->selectedItem = stdFontSelection;
  fontList->addAuditor( new ChooseFontAud());
  font->name = fontList->items[stdFontSelection];

  SbVec2i32 size = SoDialogViz::getLabelPixelSize("Render Quality:", NULL);
  rightCol->width = maxSize[0] + 30 + size[0];
  rightCol->fixedHeight = TRUE;
  rightCol->fixedWidth = TRUE;

  type = (SoDialogComboBox*)mainWindow->searchForAuditorId("type");
  type->addAuditor(new ChooseTypeAud());
  switchText->whichChild.connectFrom(&type->selectedItem);

  profile = (SoDialogCheckBox*)mainWindow->searchForAuditorId("profile");
  profile->addAuditor(new SetProfileAud());
  texture = (SoDialogCheckBox*)mainWindow->searchForAuditorId("texture");
  texture->addAuditor(new SetTextureAud());

  kerning = (SoDialogCheckBox*)mainWindow->searchForAuditorId("kerning");
  textProperty->kerning.connectFrom(&kerning->state);

  style = (SoDialogComboBox*)mainWindow->searchForAuditorId("style");
  style->addAuditor(new ChooseStyleAud());
 
  orientation = (SoDialogComboBox*)mainWindow->searchForAuditorId("orientation");
  orientation->addAuditor(new ChooseOrientationAud());

  alignH = (SoDialogComboBox*)mainWindow->searchForAuditorId("alignmentH");
  alignH->addAuditor(new ChooseAlignmentHAud());

  alignV = (SoDialogComboBox*)mainWindow->searchForAuditorId("alignmentV");
  alignV->addAuditor(new ChooseAlignmentVAud());

  fontSize = (SoDialogRealSlider*)mainWindow->searchForAuditorId("fontSize");
  font->size.connectFrom(&fontSize->value);

  quality = (SoDialogRealSlider*)mainWindow->searchForAuditorId("quality");
  complexity->value.connectFrom(&quality->value);

  color = (SoDialogRealSlider*)mainWindow->searchForAuditorId("color");
  color->addAuditor(new SetColorAud());

  margin = (SoDialogRealSlider*)mainWindow->searchForAuditorId("margin");
  textProperty->margin.connectFrom(&margin->value);

  spacing = (SoDialogRealSlider*)mainWindow->searchForAuditorId("spacing");
  text2->spacing.connectFrom(&spacing->value);
  text3->spacing.connectFrom(&spacing->value);
  annotext->spacing.connectFrom(&spacing->value);

  customText = (SoDialogEditText*)mainWindow->searchForAuditorId("customText");
  customText->addAuditor(new SetCustomTextAud());

  customTextEnable = (SoDialogCheckBox*)mainWindow->searchForAuditorId("CUSTENABL");
  customTextEnable->addAuditor(new SetCustomTextEnableAud());

  ChooseOptionAud* chooseOptAud = new ChooseOptionAud();
  optionU = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionU");
  optionU->addAuditor(chooseOptAud);
  optionS = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionS");
  optionS->addAuditor(chooseOptAud);
  optionDS = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionDS");
  optionDS->addAuditor(chooseOptAud);
  optionBF = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionBF");
  optionBF->addAuditor(chooseOptAud);
  optionBFL = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionBFL");
  optionBFL->addAuditor(chooseOptAud);
  optionOverline = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionOverline");
  optionOverline->addAuditor(chooseOptAud);

  optionUTransp = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionUTransp");
  optionUTransp->addAuditor(chooseOptAud);
  optionSTransp = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionSTransp");
  optionSTransp->addAuditor(chooseOptAud);
  optionDSTransp = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionDSTransp");
  optionDSTransp->addAuditor(chooseOptAud);
  optionBFTransp = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionBFTransp");
  optionBFTransp->addAuditor(chooseOptAud);
  optionBFLTransp = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionBFLTransp");
  optionBFLTransp->addAuditor(chooseOptAud);
  optionOverlineTransp = (SoDialogCheckBox*)mainWindow->searchForAuditorId("optionOverlineTransp");
  optionOverlineTransp->addAuditor(chooseOptAud);

  ChooseOptionColorAud* chooseOptColorAud = new ChooseOptionColorAud();
  optionUColor = (SoDialogRealSlider*)mainWindow->searchForAuditorId("optionUColor");
  optionUColor->addAuditor(chooseOptColorAud);
  optionSColor = (SoDialogRealSlider*)mainWindow->searchForAuditorId("optionSColor");
  optionSColor->addAuditor(chooseOptColorAud);
  optionDSColor = (SoDialogRealSlider*)mainWindow->searchForAuditorId("optionDSColor");
  optionDSColor->addAuditor(chooseOptColorAud);
  optionBFColor = (SoDialogRealSlider*)mainWindow->searchForAuditorId("optionBFColor");
  optionBFColor->addAuditor(chooseOptColorAud);
  optionBFLColor = (SoDialogRealSlider*)mainWindow->searchForAuditorId("optionBFLColor");
  optionBFLColor->addAuditor(chooseOptColorAud);
  optionOverlineColor = (SoDialogRealSlider*)mainWindow->searchForAuditorId("optionOverlineColor");
  optionOverlineColor->addAuditor(chooseOptColorAud);

  ChooseTexQualMinMaxAud* chooseTexQualMinMaxAud = new ChooseTexQualMinMaxAud();
  texQualityMin = (SoDialogEditText*)mainWindow->searchForAuditorId("TexQualityMin");
  texQualityMin->addAuditor(chooseTexQualMinMaxAud);
  texQualityMax = (SoDialogEditText*)mainWindow->searchForAuditorId("TexQualityMax");
  texQualityMax->addAuditor(chooseTexQualMinMaxAud);

  texAliasFactor = (SoDialogRealSlider*)mainWindow->searchForAuditorId("TexAliasFactor");
  textProperty->aliasingFactor.connectFrom(&texAliasFactor->value);

  texQuality = (SoDialogRealSlider*)mainWindow->searchForAuditorId("TexQuality");
  complexity->textureQuality.connectFrom(&texQuality->value);
}

/*************************************************************************/
int
main(int, char **argv)
//    Main demo method. Load interface and setup connections in the 
//    scene graph.
{
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) 
    exit(1);

  SoDialogViz::init();
  
  mainWindow = (SoTopLevelDialog*)SoDialogViz::loadFromFile(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/TextExtensions/TextProperties/TextPropertiesGUI.iv"));

  SoSeparator* root = buildSceneGraph();
  launchDialogVizComponents();

  mainWindow->buildDialog(myWindow, TRUE);

  // Setup text viewer  
  SoDialogCustom* customViewer = (SoDialogCustom*)mainWindow->searchForAuditorId("textViewer");
  viewer = new SoXtExaminerViewer(customViewer->getWidget());
  viewer->setBackgroundColor(SbColor(0.2f, 0.3f, 0.4f));
  viewer->setTransparencyType(SoGLRenderAction::NO_SORT);
  
  viewer->setSceneGraph(root);
  viewer->viewAll() ;
  viewer->show();


  // Add an event callback to catch mouse button presses.
  // The callback is set up later on.
  SoEventCallback *myEventCB = new SoEventCallback;
  root->insertChild(myEventCB, 0);

  // Set up the event callback. We want to pass the root of the
  // entire scene graph (including the camera) as the userData,
  // so we get the scene manager's version of the scene graph
  // root.
  myEventCB->addEventCallback(SoMouseButtonEvent::getClassTypeId(),
                              myMousePressCB,
                              viewer->getSceneManager()->getSceneGraph());


  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete viewer;
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}

