/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan Mehamli (Apr 2011)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoViewportClipping.h>

int
main( int /*argc*/, char** argv )
{
  Widget myWindow = SoXt::init( argv[0] );
  if( myWindow == NULL ) 
    exit( 1 );

  // Scene graph definition
  SoSeparator* root = new SoSeparator;
  root->ref();

  // First view situated at the bottom of the viewer
  SoSeparator* view1Sep = new SoSeparator;

  SoViewportClipping* view1 = new SoViewportClipping;
  view1->size.setValue( SbVec2f(800, 100) ); // Size of the view
  view1Sep->addChild( view1 );

  SoText2* htxt = new SoText2;
  htxt->string.setValue( "BOTTOM" );
  view1Sep->addChild( htxt );

  // Second view situated on the left of the viewer
  SoSeparator* view2Sep = new SoSeparator;

  SoViewportClipping* view2 = new SoViewportClipping;
  view2->origin.setValue( SbVec2f(0, 100) ); // Position of the view
  view2->size.setValue( SbVec2f(100, 500) ); // Size of the view
  view2Sep->addChild( view2 );
  
  SoText2* vtxt = new SoText2;
  vtxt->string.setValue( "LEFT" );
  view2Sep->addChild( vtxt );

  // Third and main view which contains the scene
  SoSeparator* mainViewSep = new SoSeparator;
  SoViewportClipping* mainView = new SoViewportClipping;
  mainView->origin.setValue( SbVec2f(100, 100) ); // Position of the view
  mainView->size.setValue( SbVec2f(700, 500) ); // Size of the view
  mainViewSep->addChild( mainView );
  mainViewSep->addChild( new SoCone );

  // Add the views to the scene graph
  root->addChild( mainViewSep );
  root->addChild( view1Sep );
  root->addChild( view2Sep );

  // Viewer creation
  SoXtExaminerViewer* myViewer = new SoXtExaminerViewer( myWindow );
  myViewer->setSceneGraph( root );
  myViewer->setBackgroundColor( SbColor(0., 0., 0.5) );
  myViewer->setSize( SbVec2s(800, 600) ) ;
  myViewer->setTitle( "View clipping test" );
  myViewer->show();

  SoXt::show( myWindow );
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  
  SoXt::finish();

  return 0;
}


