/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/////////////////////////////////////////////////////////////////////////////
//
// Classes of actions. They are numbered consecutively from 0 and can
// be used as array indices.
//

enum ActionClass {
    GRAPH_CLASS,
    EDIT_CLASS,
    SELECT_CLASS,
    GROUP_CLASS,
    INST_CLASS,
    NODE_CLASS
};

/////////////////////////////////////////////////////////////////////////////
//
// Actions to perform. The XXX_FIRST items are used with the BUT_INDEX
// macro.
//

enum ActionItem {

    GRAPH_FIRST,
    GRAPH_UPDATE,

    EDIT_FIRST,
    EDIT_CUT,
    EDIT_COPY,
    EDIT_PASTE,
    EDIT_PASTE_REF,
    EDIT_DUP,
    EDIT_DUP_REF,
    EDIT_DELETE,

    SELECT_FIRST,
    SELECT_LEFT_SIB,
    SELECT_RIGHT_SIB,
    SELECT_PARENT,
    SELECT_1ST_CHILD,

    GROUP_FIRST,
    GROUP_OPEN,
    GROUP_OPEN_ALL,
    GROUP_CLOSE,
    GROUP_TOGGLE,

    INST_FIRST,
    INST_TOGGLE,
    INST_SWAP,

    NODE_FIRST,
    NODE_CREATE,
    NODE_EDIT,

    NONE			// For separators in menus, e.g.
};

/////////////////////////////////////////////////////////////////////////////
//
// This macro is used to determine the index of action items within
// their classes. For example, BUT_INDEX(EDIT_DUP, EDIT_FIRST) returns
// the index of the EDIT_DUP action (starting at 0) within the EDIT
// actions.
//

#define ACTION_INDEX(but, first)	((but) - (first) - 1)


