/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
#include <X11/Intrinsic.h>

#include <Xm/MessageB.h>

#include "Error.h"
#include "MotifHelp.h"

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor - takes parent widget and error message.
//

Error::Error(Widget parent, const char *message)
//
////////////////////////////////////////////////////////////////////////
{
    ARG_VARS(10);

    deleteMe = TRUE;

    ADD_ARG(XmNmessageString,
	    XmStringCreateLtoR((char *) message, XmSTRING_DEFAULT_CHARSET));
    widget = XmCreateErrorDialog(parent, (char *)"Error", ARGS);

    // Get rid of buttons we don't need
    XtUnmanageChild(XmMessageBoxGetChild(widget, XmDIALOG_CANCEL_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(widget, XmDIALOG_HELP_BUTTON));

    // Set up callbacks to use "this"
    XtAddCallback(widget, XmNdestroyCallback,
		  (XtCallbackProc) &Error::destroyCB, (XtPointer) this);
    XtAddCallback(widget, XmNokCallback,
		  (XtCallbackProc) &Error::okCB,  (XtPointer) this);

    // Display widget
    XtManageChild(widget);
}    

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor.
//

Error::~Error()
//
////////////////////////////////////////////////////////////////////////
{
    // Hide widget
    XtUnmanageChild(widget);
    XtDestroyWidget(widget);
}    

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Callback called when the widget is destroyed. The clientData
//    pointer points to a Error instance.
//

void
Error::destroyCB(Widget, XtPointer clientData, XtPointer)
//
////////////////////////////////////////////////////////////////////////
{
    // Note that this will be called when the ok button is pressed, so
    // be careful!!!!

    Error	*err = (Error *) clientData;

    // Make sure we haven't already started the deletion of the error-box
    if (err->deleteMe) {
	err->deleteMe = FALSE;
	delete err;
    }
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Callback called when the "Ok" button in the error-box is
//    activated. The clientData pointer points to a Error instance.
//

void
Error::okCB(Widget, XtPointer clientData, XtPointer)
//
////////////////////////////////////////////////////////////////////////
{
    Error	*err = (Error *) clientData;

    err->deleteMe = FALSE;
    delete err;
}


