/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/////////////////////////////////////////////////////////////////////////////
//
// Types of menu buttons.
//

enum ButtonType {
    SEPARATOR, 
    PUSH, 
    TOGGLE
};

/////////////////////////////////////////////////////////////////////////////
//
// Button description structure.
//

struct ButtonInfo {
    const char	*name;		// Name on button
    ActionItem	actionItem;	// Corresponding action code
    ButtonType	type;		// Type of button
    const char	*accelerator;	// Passed to Motif
    const char	*accelDisplay;	// Displayed in button
    GraphViewer	*viewer;	// Pointer to viewer instance
    Widget	widget;		// Button widget
};

/////////////////////////////////////////////////////////////////////////////
//
// Pulldown description structure.
//

struct PulldownInfo {
    const char *name;		// Name on top of menu
    ActionClass actionClass;	// Class of actions in menu
    ButtonInfo *buttons;	// Array of button info
    int numButtons;		// Number of buttons
    GraphViewer *viewer;	// Pointer to viewer instance
};

/////////////////////////////////////////////////////////////////////////////
//
// Button descriptions for each pulldown menu. The order of the
// buttons within a pulldown MUST match the order of the action codes.
//

static ButtonInfo	graphButtons[] = {
    { "Update", GRAPH_UPDATE,	PUSH,		"Alt <Key> u",	"Alt+u", NULL, NULL	},
};

static ButtonInfo	editButtons[] = {
    { "Cut", 	     EDIT_CUT,	     PUSH,	"Alt <Key> x",	"Alt+x", NULL, NULL	},
    { "Copy", 	     EDIT_COPY,	     PUSH,	"Alt <Key> c",	"Alt+c", NULL, NULL	},
    { "Paste",	     EDIT_PASTE,     PUSH,	"Alt <Key> v",	"Alt+v", NULL, NULL	},
    { "Paste Reference",
         EDIT_PASTE_REF, PUSH,"Alt Shift <Key> v",	"Alt+V", NULL, NULL	},
    { "Duplicate",   EDIT_DUP,	     PUSH,	"Alt <Key> d",	"Alt+d", NULL, NULL	},
    { "Duplicate by Reference",
         EDIT_DUP_REF,   PUSH,"Alt Shift <Key> d",	"Alt+D", NULL, NULL	},
    { "Delete",      EDIT_DELETE,    PUSH,  "<Key> BackSpace",	"BackSpace", NULL, NULL },
};

static ButtonInfo	selectButtons[] = {
    { "Left Sibling", SELECT_LEFT_SIB, PUSH, "<Key> Left",	"Left Arrow", NULL, NULL },
    { "Right Sibling",SELECT_RIGHT_SIB,PUSH, "<Key> Right",	"Right Arrow", NULL, NULL},
    { "Parent",	      SELECT_PARENT,   PUSH, "<Key> Up",	"Up Arrow", NULL, NULL },
    { "First Child",  SELECT_1ST_CHILD,PUSH, "<Key> Down",	"Down Arrow", NULL, NULL},
};

static ButtonInfo	groupButtons[] = {
    { "Open", 	 GROUP_OPEN,	PUSH,		"Alt <Key> o",	"Alt+o", NULL, NULL	},
    { "Open All",GROUP_OPEN_ALL,PUSH,	  "Alt Shift <Key> o",	"Alt+O", NULL, NULL	},
    { "Close", 	 GROUP_CLOSE,	PUSH,		"Alt <Key> k",	"Alt+k", NULL, NULL	},
    { "Toggle",	 GROUP_TOGGLE,	PUSH,		"Alt <Key> t",	"Alt+t", NULL, NULL	},
};

static ButtonInfo	instButtons[] = {
    { "Toggle",	INST_TOGGLE,	PUSH,		"Alt <Key> i",	"Alt+i", NULL, NULL	},
    { "Swap", 	INST_SWAP,	PUSH,		"Alt <Key> w",	"Alt+w", NULL, NULL	},
};

static ButtonInfo	nodeButtons[] = {
    { "Create",	     NODE_CREATE, PUSH,		"Alt <Key> n",	"Alt+n", NULL, NULL	},
    { "Edit Fields", NODE_EDIT,	  PUSH,		"Alt <Key> f",	"Alt+f", NULL, NULL	},
};

/////////////////////////////////////////////////////////////////////////////
//
// Pulldown descriptions.
//

static PulldownInfo	pullInfos[] = {
    { "Graph",	GRAPH_CLASS,	graphButtons,	XtNumber(graphButtons), NULL	},
    { "Edit",	EDIT_CLASS,	editButtons,	XtNumber(editButtons), NULL	},
    { "Select",	SELECT_CLASS,	selectButtons,	XtNumber(selectButtons), NULL	},
    { "Group",	GROUP_CLASS,	groupButtons,	XtNumber(groupButtons), NULL	},
    { "Inst",	INST_CLASS,	instButtons,	XtNumber(instButtons), NULL	},
    { "Node",	NODE_CLASS,	nodeButtons,	XtNumber(nodeButtons), NULL	},
};

/////////////////////////////////////////////////////////////////////////////
//
// Number of pulldowns.
//

#define NUM_PULLDOWNS 	XtNumber(pullInfos)


