/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

class SoNode;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: NodeCreator
//
//  Widget class that is used to create a new node.
//
//////////////////////////////////////////////////////////////////////////////

// Type of callback function passed to constructor. newNode is NULL
// if no valid node was created
typedef void	NodeCreatorCB(void *userData, SoNode *newNode);

class NodeCreator {

  public:
    // Constructor - takes parent widget and callback to call when a
    // node name is selected
    NodeCreator(Widget parent, NodeCreatorCB *cb, const void *userData);

    // Destructor
    ~NodeCreator();

  private:
    NodeCreatorCB	*finishCB;	// Finish callback (NULL if none)
    void		*finishData;	// User data for callback
    SbBool		deleteMe;	// If should be deleted in destroyCB
    static Widget	widget;		// Widget
    static Widget	selBox;		// Selection box widget

    // Builds widget
    void		buildWidget(Widget parent);

    // Callback for when a creator is destroyed
    static void		destroyCB(Widget, XtPointer, XtPointer);

    // Callback for when a button is pressed
    static void		acceptCB(Widget, XtPointer, XtPointer);
    static void		cancelCB(Widget, XtPointer, XtPointer);

    // Returns text part of first segment of compound string
    static char *	decodeString(XmString string);

    // Returns an array of XmStrings containing the names of all known
    // node classes
    void		getNodeNames(XmString *&strings, int &numStrings);

    // Used to sort the node names for getNodeNames()
    static int		nameCompare(const void *, const void *);

    // Creates instance of named node and calls user's callback
    // function. The name may be a NULL pointer.
    void		invokeCallback(const char *nodeName);
};


