/*
** Copyright 1995, Template Graphics Software, Inc.
** All Rights Reserved.
**
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of Template Graphics Software, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of Template Graphics Software, Inc.
**
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
**
*/

#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>

#define	TGS_PRINT_NO_RENAMES
#include "print.h"

static BOOL gotconsole = FALSE;
static FILE *tee;

extern BOOL __is_win32s(void);

#define __is_win32s() FALSE

FILE *
__GetConsole(void)
{
	return tee;
}

FILE *
__AllocConsole(void)
{
  AllocConsole();
  {
    HANDLE hFile = GetStdHandle(STD_OUTPUT_HANDLE);
    int nHandle = _open_osfhandle((uintptr_t)hFile,_O_WRONLY);

    tee = _fdopen(nHandle, "w");
  }
  gotconsole = TRUE;

  return tee;
}

// Needed so that we can pass GSIM_TEE on command line 
// (for Win32s).  The command line may not be processed until 
// after the first printf's been called, so we need to be able 
// force a re-initialization.
void 
__OIV__print_init(int force)
{
  if (force) {
    gotconsole = FALSE;
  }
}

int 
__OIV_printf(const char *fmt, ...)
{
  int rv;
  va_list arg;

  va_start(arg, fmt);
  rv = __OIV_vprintf(fmt, arg);
  va_end(arg);

  return rv;
}

int 
__OIV_vprintf(const char *fmt, va_list arg)
{
  int rv=0;

  if (!gotconsole) {
    __AllocConsole();
  }
  //rv = vprintf(fmt, arg);
  if (tee) {
    rv = vfprintf(tee,fmt,arg);
  }
  _flushall();

  return rv;
}

int 
__OIV_fprintf(FILE *s, const char *fmt, ...)
{
  int rv;
  va_list arg;

  va_start(arg, fmt);
  rv = __OIV_vfprintf(s, fmt, arg);
  va_end(arg);

  return rv;
}

int 
__OIV_vfprintf(FILE *s, const char *fmt, va_list arg)
{
  int rv=0;

  if (s == stdin) {
    return -1;
  }
  if (s == stdout || s == stderr || s == stdprn || s == stdaux) {
    if (!gotconsole) {
      __AllocConsole();
    }
    //rv = vprintf(fmt, arg);
    if (tee) {
      rv = vfprintf(tee,fmt,arg);
    }
    _flushall();
  }
  else {
    rv = vfprintf(s, fmt, arg);
  }
  return rv;
}

int 
__OIV_fflush(FILE *s)
{
  if (s == stdin) {
    return 0;	// GMT: fflush returns 0 for read only streams
  }
  else if (s == stdout || s == stderr || s == stdprn || s == stdaux) {
    _flushall();
    return 0;
  }

  return fflush(s);
}

void 
__OIV_exit(int rv)
{
  if (gotconsole) {
    __OIV_printf("\nEXITING WITH STATUS %d\n", rv);
    if (tee) {
      fclose(tee);
    }
    if (rv) {
      Sleep(INFINITE);
    }
  }
  exit(rv);
  /* NOTREACHED */
}


