/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM yyyy)
**=======================================================================*/

#include <Inventor/Qt/SoQt.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/touch/devices/SoQtTouchScreen.h>
#include "SoDragGestureRecognizer.h"
#include <Inventor/nodes/SoMaterial.h>

SoOrthographicCamera *myCamera;
SoQtRenderArea *myRenderArea;
SoMaterial* color;

void myDragCB(void* /*userData*/, SoEventCallback *eventCB)
{
  SoDragGestureEvent *dragEvent = (SoDragGestureEvent*)eventCB->getEvent();
  SbColor init = color->diffuseColor[0];
  SbVec2f dist = dragEvent->getDraggedDistance();

  color->diffuseColor.setValue(init[0] + dist[0]/10000, init[1] + dist[1]/10000, init[2]);
  eventCB->setHandled();
}

int main(int, char **argv)
{
  SoDragGestureRecognizer dragGestureRecognizer;

  Widget appWindow = SoQt::init(argv[0]);
  if (appWindow == NULL) exit(1);

  // Create and set up the root node
  SoSeparator *root = new SoSeparator;
  root->ref();

  // Add a camera
  myCamera = new SoOrthographicCamera;
  myCamera->position.setValue(0.0f, 0.0f, 4.0f);
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  
  color = new SoMaterial;
  root->addChild(color);
  SoCone* cone = new SoCone;
  root->addChild(cone);

  myRenderArea = new SoQtRenderArea(appWindow);

  SoEventCallback *myEventCB = new SoEventCallback;

  SoDragGestureEvent::initClass();

  myEventCB->addEventCallback(SoDragGestureEvent::getClassTypeId(), myDragCB, myRenderArea->getSceneManager()->getSceneGraph());
  root->addChild(myEventCB);

  // Register the touch screen device.
  SoQtTouchScreen touchScreenDevice(appWindow);
  myRenderArea->registerDevice(&touchScreenDevice);

  touchScreenDevice.getTouchManager()->addRecognizer(&dragGestureRecognizer);

  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("DragGestureRecognizer");

  // Make the camera see the whole scene
  SbViewportRegion viewportRegion = myRenderArea->getViewportRegion();
  myCamera->viewAll(root, viewportRegion, 2.0f);
  
  // Show our application window, and loop forever...
  myRenderArea->show();
  SoQt::show(appWindow);
  SoQt::mainLoop();

  root->unref();

  SoDragGestureEvent::exitClass();

  delete myRenderArea;
  SoQt::finish();

  return 0;
}
