
#ifndef  _SO_DRAG_GESTURE_EVENT_
#define  _SO_DRAG_GESTURE_EVENT_

#include <Inventor/gestures/events/SoGestureEvent.h>

/** 
 *    SoDragGestureEvent represents drag gesture with two fingers in the Open Inventor event model.
 *    Every events are analyzed by a SoDragGestureRecognizer. When a drag gesture is recognized, 
 *    the recognizer release drag gesture event.
 *    The gesture begin with a begin state. Drag events are released until end state.
 *    SoDragGestureEvent represents the distance between the current state and the initial one. 
 *    Positions are middle of the segment defined by the two fingers
 *    
 */ 

class SoDragGestureEvent : public SoGestureEvent {

  SO_EVENT_HEADER();

public :

  SoDragGestureEvent();

  virtual ~SoDragGestureEvent();

  /**
   *  Gets the distance between the current fingers distance and the first
   *  distance evaluated after the second down event.
   */
  SbVec2f getDraggedDistance() const;

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  /**
   *  Sets the distance between the current fingers position and the first
   *  position evaluated after the second down event.
   */
  void setDraggedDistance(SbVec2f r);

private :
  // The distance between the current fingers distance and the first distance
  SbVec2f m_draggedDistance;
};

#endif /* _SO_DRAG_GESTURE_EVENT_ */
