/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include "SoDragGestureRecognizer.h"
#include <Inventor/touch/events/SoTouchEvent.h>

SoDragGestureRecognizer::SoDragGestureRecognizer()
{
  m_finger1ID = std::numeric_limits<unsigned int>::max();
  m_finger2ID = std::numeric_limits<unsigned int>::max();
  m_recoInProgress = false;
  maximumDistanceBetweenFingers = 200;
}

SoDragGestureRecognizer::~SoDragGestureRecognizer()
{
}

void SoDragGestureRecognizer::setMaximumDistanceBetweenFingers(float dis)
{
  maximumDistanceBetweenFingers = dis;
}

float SoDragGestureRecognizer::getMaximumDistanceBetweenFingers(void)
{
  return maximumDistanceBetweenFingers;
}

SoEvent* SoDragGestureRecognizer::recognize(SoEvent* touchEvent) 
{
  SoTouchEvent* dragTouchEvent = dynamic_cast <SoTouchEvent*>(touchEvent);
  SbVec2f otherFingerPosition;
  SbVec2f otherFingerFirstPosition;
  SbVec2f position = dragTouchEvent->getPositionFloat();

  SoTouchManager* touchManager = dragTouchEvent->getTouchManager();

  if (dragTouchEvent==0)
    return NULL;

  // If the recognizer is turned on
  if (m_recoInProgress)
  {
    // If you put up one of your finger, the recognition is endeed and the recognizer return
    // an event with the END attribute.
    if(dragTouchEvent->getState() == SoTouchEvent::UP)
    {
      if(dragTouchEvent->getFingerId() == m_finger1ID)
      {
        m_finger1ID = std::numeric_limits<unsigned int>::max();
      }
      else if (dragTouchEvent->getFingerId() == m_finger2ID)
      {
        m_finger2ID = std::numeric_limits<unsigned int>::max();
      }
      m_returnedEvent.setGestureState(SoGestureEvent::END);
      m_recoInProgress = false;
      return &m_returnedEvent;
    }
    // If it's not a UP, two fingers are moving on the screen. The position of the other finger is recovered.
    // and the distance between fingers is updated to calculate the new distance.
    else 
    {
      if(dragTouchEvent->getFingerId() == m_finger1ID)
      {
        otherFingerPosition = touchManager->getEventById(m_finger2ID)->getPositionFloat();
        otherFingerFirstPosition = touchManager->getEventById(m_finger2ID)->getFirstPosition();
      }
      else if (dragTouchEvent->getFingerId() == m_finger2ID) 
      {
        otherFingerPosition = touchManager->getEventById(m_finger1ID)->getPositionFloat();
        otherFingerFirstPosition = touchManager->getEventById(m_finger1ID)->getFirstPosition();
      }
      if( (position - otherFingerPosition).lengthSquared() < maximumDistanceBetweenFingers*maximumDistanceBetweenFingers)
      {
        SbVec2f pos = (position + otherFingerPosition )/2;
        m_returnedEvent.setPosition(pos);
        m_returnedEvent.setDraggedDistance(pos - (dragTouchEvent->getFirstPosition() +  otherFingerFirstPosition)/2 );
        m_returnedEvent.setGestureState(SoGestureEvent::DELTA);
        return &m_returnedEvent;
      }
    }
  }
  // If the recognizer is turned off.
  else
  {
    if(dragTouchEvent->getState() == SoTouchEvent::UP)
    {
      if (dragTouchEvent->getFingerId() == m_finger1ID)
      {
        m_finger1ID = std::numeric_limits<unsigned int>::max();
      }
    }
    // if one finger is put down the sreen
    else if(dragTouchEvent->getState() == SoTouchEvent::DOWN)
    {
      if(m_finger1ID == std::numeric_limits<unsigned int>::max())
      {
        m_finger1ID = dragTouchEvent->getFingerId();
      }
      // and an other finger is touch the screen too.
      else if (dragTouchEvent->getFingerId() != m_finger1ID) {
        m_finger2ID = dragTouchEvent->getFingerId();
			
        otherFingerPosition = touchManager->getEventById(m_finger1ID)->getPositionFloat();
        otherFingerFirstPosition = touchManager->getEventById(m_finger1ID)->getFirstPosition();

        if( (position - otherFingerPosition).lengthSquared() < maximumDistanceBetweenFingers*maximumDistanceBetweenFingers)
        {
          SbVec2f pos = (position + otherFingerPosition )/2;
          m_returnedEvent.setDraggedDistance(pos - (dragTouchEvent->getFirstPosition() +  otherFingerFirstPosition)/2 );

          m_returnedEvent.setGestureState(SoGestureEvent::BEGIN);
          m_recoInProgress = true;
          return &m_returnedEvent;
        }
      }
    }
  }
  return NULL;
}
