
#ifndef  _SO_DRAG_GESTURE_RECOGNIZER_
#define  _SO_DRAG_GESTURE_RECOGNIZER_

#include <Inventor/gestures/recognizers/SoGestureRecognizer.h>
#include "SoDragGestureEvent.h"
#include <Inventor/touch/SoTouchManager.h>

/** 
 *   SoDragGestureRecognizer analyses all events and returns a drag event if this gesture is recognized (draging together two fingers). 
 *   The drag event contains the dragged distance between the current state and the initial one.
 *   This recognizer always begin generating a begin SoDragGestureEvent followed by delta events and finishing with end event.
 */ 

class SoDragGestureRecognizer : public SoGestureRecognizer {
public :

  SoDragGestureRecognizer();

  virtual ~SoDragGestureRecognizer();

  float getMaximumDistanceBetweenFingers(void);
  
  void setMaximumDistanceBetweenFingers(float dis);
  
  /**
   * If two fingers are moving on the screen, it returns an event with the distance between the current 
   * position and the initial one when the second finger was put down.
   */
  SoEvent* recognize(SoEvent* touchEvent); 
  
private:
  unsigned int m_finger1ID;
  unsigned int m_finger2ID;
  bool m_recoInProgress;
  float maximumDistanceBetweenFingers;
  SoDragGestureEvent m_returnedEvent;
};

#endif /* _SO_DRAG_GESTURE_RECOGNIZER_ */
