/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM yyyy)
**=======================================================================*/

#include <Inventor/Qt/SoQt.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/touch/events/SoTouchEvent.h>
#include <Inventor/touch/devices/SoQtTouchScreen.h>
#include <Inventor/nodes/SoMaterial.h>

SoOrthographicCamera *myCamera;
SbViewVolume myViewVolume;
SoQtRenderArea *myRenderArea;
SoLineSet* myLineSet1,*myLineSet2;
SoVertexProperty *myVertexProp1,*myVertexProp2;

// Vertex number for the current line
int numVextexInTheLine1, numVextexInTheLine2;
unsigned long idLine1, idLine2;
bool drowingLine1, drowingLine2;
// Total vertex number
int numVertex1, numVertex2;
int numLines1, numLines2;

void
  myTouchCB(void* /*userData*/, SoEventCallback *eventCB)
{
  SoTouchEvent *event = (SoTouchEvent*)eventCB->getEvent();
  SbVec2f vec = event->getPositionFloat();
	
  if (event->getState() == SoTouchEvent::DOWN )
  {
    if(event->getFingerId() != idLine1 && event->getFingerId() != idLine2)
    {
      if(!drowingLine2) {
        idLine2 = event->getFingerId();
        drowingLine2 = true;
	    }
      else if(!drowingLine1) {
        idLine1 = event->getFingerId();
        drowingLine1 = true;
      }
    }
  }

  SbVec2s size = myRenderArea->getSceneManager()->getSize();
  vec[0] = vec[0]/size[0];
  vec[1] = vec[1]/size[1];

  const SbViewportRegion &region = myRenderArea->getViewportRegion();
  float aspect = region.getViewportAspectRatio();

  myViewVolume = myCamera->getViewVolume( aspect );
  if ( aspect < 1 )
    myViewVolume.scale( 1 / aspect );

  // Project the point to a line
  SbVec3f line1,line2;
  myViewVolume.projectPointToLine(vec,line1,line2);

  SbVec3f* coords;
  if(event->getFingerId() == idLine1) {
    if (event->getState() == SoTouchEvent::UP ) {
      numLines1++;
	    numVextexInTheLine1 = 0;
      idLine1 = ULONG_MAX;
	    drowingLine1 = false;
	  }
		
	  else {
      myVertexProp1->vertex.insertSpace(myVertexProp1->vertex.getNum(),1);
      coords = myVertexProp1->vertex.startEditing();
      numVextexInTheLine1++;
	    coords[numVertex1]= line1; 
	    myLineSet1->numVertices.set1Value(numLines1,numVextexInTheLine1);
	    numVertex1++;
	    myVertexProp1->vertex.finishEditing();
	  }
  }
  else if(event->getFingerId() == idLine2){
    if (event->getState() == SoTouchEvent::UP ) {
      numLines2++;
	    numVextexInTheLine2 = 0;
      idLine2 = ULONG_MAX;
	    drowingLine2 = false;
	  }
	  else {
      myVertexProp2->vertex.insertSpace(myVertexProp2->vertex.getNum(),1);
      coords = myVertexProp2->vertex.startEditing();
	    numVextexInTheLine2++;
	    coords[numVertex2]= line1; 
	    myLineSet2->numVertices.set1Value(numLines2,numVextexInTheLine2);
	    numVertex2++;
	    myVertexProp2->vertex.finishEditing();
	  }
  }
  eventCB->setHandled();
}

int
  main(int, char **argv)
{
  idLine1 = ULONG_MAX;
  idLine2 = ULONG_MAX;
  drowingLine1 = false;
  drowingLine2 = false;
  // Print out usage instructions
  printf("\tTouch to draw\n");
  
  // Initialize Inventor and Xt
  QWidget *appWindow = SoQt::init(argv[0]);
  if (appWindow == NULL) exit(1);
  
  // Create and set up the root node
  SoSeparator *root = new SoSeparator;
  root->ref();

  // Add a camera
  myCamera = new SoOrthographicCamera;
  myCamera->position.setValue(0.0f, 0.0f, 4.0f);
  root->addChild(myCamera);
  
  root->addChild(new SoDirectionalLight);
  
  myLineSet1 = new SoLineSet;
  myVertexProp1 = new SoVertexProperty;
  myLineSet2 = new SoLineSet;
  myVertexProp2 = new SoVertexProperty;
  myLineSet1->vertexProperty.setValue(myVertexProp1);
  myLineSet2->vertexProperty.setValue(myVertexProp2);
  SoMaterial *lineMaterial1 = new SoMaterial;
  SoMaterial *lineMaterial2 = new SoMaterial;
  lineMaterial1->diffuseColor.setValue(0.0f, 0.0f, 0.8f);
  lineMaterial2->diffuseColor.setValue(0.8f, 0.0f, 0.0f);
  root->addChild(lineMaterial1);
  root->addChild(myLineSet1);
  root->addChild(lineMaterial2);
  root->addChild(myLineSet2);
  
  SoEventCallback *myEventCB = new SoEventCallback;
  myEventCB->addEventCallback(SoTouchEvent::getClassTypeId(), myTouchCB, root);
  root->addChild(myEventCB);

  myRenderArea = new SoQtRenderArea(appWindow);
  
  // Register the touch screen device.
  SoQtTouchScreen touchScreenDevice(appWindow);
  myRenderArea->registerDevice(&touchScreenDevice);
  
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("FingerDraw");
  
  // Make the camera see the whole scene
  SbViewportRegion viewportRegion = myRenderArea->getViewportRegion();

  myCamera->viewAll(root, viewportRegion, 2.0f);

  // Show our application window, and loop forever...
  myRenderArea->show();
  SoQt::show(appWindow);
  SoQt::mainLoop();
  
  root->unref();
  delete myRenderArea;
  SoQt::finish();
  
  return 0;
}




