/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
//
// Inventor base class for scene graphs that can be used as
// Backgrounds (static and animated).
//
// Backgrounds should typically be the first child of a LayerGroup.
// They have their own cameras, sensors, etc.  Note that when being
// used with a Viewer, the program should do the following:
//
// Create a LayerGroup.
// Create the Background, and add it as the first child of the
// LayerGroup.
// Create the 'main' scene graph.
// Add a camera to the 'main' scene graph if it doesn't have one.
// Create the Viewer.
// Pass the LayerGroup to the setSceneGraph method of the viewer
// Pass the camera created or found to the setCamera method of the
// viewer (or the viewer will incorrectly use the Background's
// camera).
//

#include <Inventor/SbBasic.h>

class SoNode;
class SoGroup;
class SoCoordinate3;
class SoBaseColor;
class SbColor;
class SbVec3f;
class SoSensor;
class SoTimerSensor;

//
// Base class; this also functions as a blank background.
//
class Background
{
  public:
    Background();
    virtual ~Background();

    // Returns scene graph rep of the background
    virtual SoNode *getSceneGraph() { return sceneGraph; }

  protected:
    SoGroup *sceneGraph;
};

//
// Class derived from code written by Drew Olbrich
//
class FlashBackground : public Background
{
  public:
    FlashBackground(int size = 12);
    ~FlashBackground();
    
    void animateShape(double t);
    void animateColor(double t);

    enum Shape {
	SHAPE_CLOUDS, SHAPE_FLAT, SHAPE_SWIRL, SHAPE_PINCH,
	SHAPE_WAVY, SHAPE_SCRUNCH, SHAPE_WALLS, SHAPE_PULL,
	NUM_SHAPES
    };

    enum Shade {
	SHADE_HAZY, SHADE_BARS, SHADE_STATIC, SHADE_FOG, SHADE_MARBLE,
	NUM_SHADES
    };

    enum Scheme {
	COLOR_GRAY, COLOR_NOISE, COLOR_PURPLE, COLOR_SUNSET, COLOR_ABYSS,
	NUM_SCHEMES
    };

  private:
    int meshSize;
    double *hash_table;
    SoCoordinate3 *coordinates;
    SoBaseColor *colors;
    SbVec3f **shapeTable;
    SbColor **schemeTable;
    Shape currentShape;
    Scheme currentScheme;
    Shape nextShape;
    Scheme nextScheme;

    double Noise(uint32_t, uint32_t, uint32_t);
    double Noise(SbVec3f &);
    double Turbulence(SbVec3f &, int);
    void shapeFunction(Shape, SbVec3f &);
    double shadeFunction(Shade, double, double);
    void colorFunction(Scheme, SbColor &, double);
    void calculateShape(Shape, SbVec3f *);
    void calculateColor(Shade, Scheme, SbColor *);
    void updateSceneShape(double);
    void updateSceneColor(double);
};

