/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
//
// Simple class that encapsulates some information about a quad-mesh
//
#include <Inventor/SbLinear.h>
#include <Inventor/SbPList.h>

class SoNode;
class SoCoordinate3;
class SoNormal;
class SoMaterial;
class SoMaterialBinding;
class SoTexture2;
class SoTextureCoordinate2;
class SoTextureCoordinateBinding;
class SoQuadMesh;
class SoSeparator;
class SoCallbackAction;

class QuadThing
{
  public:

    //
    // Create a quad-mesh from another quad-mesh
    //
    QuadThing(const QuadThing *);

    //
    // Create a quad-mesh with the given dimensions and vertices.
    //
    QuadThing(int nx, int ny, const SbVec3f *verts);

    //
    // Read in a scene graph from a file and fill in the QuadThing
    // appropriately.  If there is a problem reading the file (it
    // doesn't contain a QuadMesh, for example) this returns FALSE.
    //
    QuadThing(const char *filename);

    ~QuadThing();

    //
    // Interpolate between two things.  This also figures out new
    // normals.
    //
    void interp(const QuadThing *from, const QuadThing *to, float time);

    //
    // Get the scene graph representation for this QuadThing.  If the
    // QuadThing is later changed (via setVertices or interp) this
    // scene graph is automatically changed, too.  This scene graph
    // does not include materials or textures (so GL tricks can be
    // used to interpolate them).
    //
    SoSeparator *getSceneGraph();

    //
    // Get the materials node.  Returns NULL if there were no
    // materials defined.
    //
    SoMaterial *getMaterial();
    SoMaterialBinding *getMatBinding();

    //
    // Get the texture and texture coordinates.  Again, returns NULL
    // if there are none.
    //
    SoTexture2 *getTexture2();
    SoTextureCoordinate2 *getTexCoord();
    SoTextureCoordinateBinding *getTexBinding();

  private:
    SoSeparator *sceneGraph;	// Scene graph components
    SoCoordinate3 *coords;
    SoNormal *norms;
    SoQuadMesh *qmesh;

    SoMaterial *materials;
    SoMaterialBinding *matbind;

    SoTexture2 *texture;
    SoTextureCoordinate2 *texcoords;
    SoTextureCoordinateBinding *texbind;

    void createSceneGraph();
    void figureNormals();
    void averageNormals(SbVec3f *, int row, int column);
    void newell4(SbVec3f &n, int v1, int v2, int v3, int v4);
    void scaleBBox();
};

class QuadThingList : public SbPList
{
  public:
    void	append(QuadThing *q)
	{ ((SbPList *) this)->append((void *) q); }

    // Inserts given integer in list before integer with given index
    void	insert(QuadThing *q, int addBefore)
	{ ((SbPList *) this)->insert((void *) q,
		addBefore); }

    QuadThing *   operator [](int i) const
	{ return ( (QuadThing *) ( (*(const SbPList *) this) [i] ) ); }
};
    


