/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
//
// Surface of revolution program
//

#include "../common/InventorLogo.h"

#include <stdio.h>
#include <getopt.h>
#include <math.h>
#include <malloc.h>
#include <unistd.h>

#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/Xt/SoXtClipboard.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/sys/SoGL.h>

#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/ScrollBar.h>
#include <Xm/PushBG.h>
#include <Xm/LabelG.h>
#include <Xm/ToggleBG.h>
#include <Xm/RowColumn.h>

#include "LineManip.h"
#include "RevClass.h"

//
// These are defined in profile.c++
//
extern SoNode *createProfileGraph(Widget, RevolutionSurface *);
extern void clearPoints();

//
// Callback for 'About...' button
//
void
showAboutDialog(Widget, XtPointer, XtPointer)
{
    if (access("/usr/demos/Inventor/revo.about", R_OK) != 0)
    {
	return;
    }

    char command[100];
    sprintf(command, "showcase -v /usr/demos/Inventor/revo.about");

    int err = system(command);
    if (err)
    {
	system("xconfirm -t 'You must install showcase"
	       " for this function to work' > /dev/null");
	return;
    }
}	

//
// Called by the quit button
//
static void
quitCallback(Widget, XtPointer, XtPointer)
{
    exit(0);
}

//
// Callback for the text widget (called when the user hits return).
//
void
changeNumSides(Widget textWidget, XtPointer data, XtPointer)
{
    static char t[4];
    char *str = XmTextGetString((Widget)textWidget);
    int NumSides = atoi(str) + 1;
    if (NumSides < 4) NumSides = 4;

    sprintf(t, "%d", (NumSides-1) % 1000);
    XmTextSetString((Widget)textWidget, t);

    XtFree(str);

    RevolutionSurface *s = (RevolutionSurface *)data;
    s->changeNumSides(NumSides);
}

//
// Callback for the copy button.  Copies the surface of revolution to
// the clipboard.
//
static void
copyCallback(Widget, XtPointer vwr, XtPointer cbstruct)
{
    static SoXtClipboard *theClipboard = NULL;

    SoXtExaminerViewer *v = (SoXtExaminerViewer *)vwr;

    if (theClipboard == NULL)
    {
	theClipboard = new SoXtClipboard(v->getWidget());
    }
    SoNode *root = v->getSceneGraph();
    theClipboard->copy(root,
	((XmAnyCallbackStruct *)cbstruct)->event->xbutton.time);
}

static void
clearCallback(Widget, XtPointer, XtPointer)
{
    clearPoints();
}


////////////////////////////////////////////////////////////////////////
//
//  main
//
////////////////////////////////////////////////////////////////////////

int main(int, char **argv)
{
    Widget w = SoXt::init(argv[0]);
    if (w == NULL) exit(1);
    
    LineManip2::initClass();
    
    RevolutionSurface *revSurf = new RevolutionSurface();

    Arg resources[20];	
    int n = 0;
    XtSetArg(resources[n], (char *)"width", 800); n++;
    XtSetArg(resources[n], (char *)"height", 400); n++;
    Widget form = XmCreateForm(w, (char *)"form", resources, n); n = 0;
    
    //
    // This RowColumn widget holds all the stuff at the bottom
    // of the screen
    //
    XtSetArg(resources[n], XmNorientation, XmHORIZONTAL); ++n;
    XtSetArg(resources[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(resources[n], XmNadjustLast, FALSE); ++n;
    XtSetArg(resources[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(resources[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    Widget rc = XmCreateRowColumn(form, (char *)"bottomStuff", resources, n); 
    n = 0;
    
    //
    // Add the viewer to view the shaded geometry
    // 
    XtSetArg(resources[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(resources[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(resources[n], XmNleftPosition, 50); n++;
    XtSetArg(resources[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(resources[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(resources[n], XmNbottomWidget, rc); n++;
    Widget frame2 = XmCreateFrame(form, (char *)"renderAreaFrame", resources, n); 
    n = 0;

    SoXtExaminerViewer *examViewer = new SoXtExaminerViewer(frame2);
    examViewer->setSceneGraph(revSurf->getSceneGraph());
    examViewer->setBorder(FALSE);
    examViewer->setDecoration(FALSE);
    examViewer->show();
    XtManageChild(frame2);
    
    //
    // Add viewer to edit the revolution profile
    //
    XtSetArg(resources[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(resources[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(resources[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(resources[n], XmNrightPosition, 50); n++;
    XtSetArg(resources[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(resources[n], XmNbottomWidget, rc); n++;
    Widget frame1 = XmCreateFrame(form, (char *)"renderAreaFrame", resources, n); 
    n = 0;

    SoXtRenderArea *ra = new SoXtRenderArea(frame1);
    ra->setSceneGraph(createProfileGraph(ra->getWidget(), revSurf));
    ra->setBorder(FALSE);
    ra->show();
    XtManageChild(frame1);

#define STRING(a) XmStringCreate((char *)a, XmSTRING_DEFAULT_CHARSET)
    
    XtSetArg(resources[n], XmNlabelString, STRING("# sides:")); ++n;
    Widget nsidesLabel = XmCreateLabelGadget(
		rc, (char *)"nsidesLabel", resources, n); 
    n = 0;
    XtManageChild(nsidesLabel);
    
    XtSetArg(resources[n], XmNvalue, "20"); ++n;
    XtSetArg(resources[n], XmNcolumns, 3); ++n;
    XtSetArg(resources[n], XmNeditMode, XmSINGLE_LINE_EDIT); ++n;
    Widget nsidesEdit = XmCreateText(
		rc, (char *)"nsidesEdit", resources, n); 
    n = 0;
    XtAddCallback(nsidesEdit, XmNactivateCallback, 
		changeNumSides, (XtPointer)revSurf);
    XtManageChild(nsidesEdit);
    
    XtSetArg(resources[n], XmNlabelString, STRING("Copy")); ++n;
    Widget copyButton = XmCreatePushButtonGadget(
		rc, (char *)"copy", resources, n); 
    n = 0;
    XtAddCallback(copyButton, XmNactivateCallback,
		  copyCallback, (XtPointer)examViewer);
    XtManageChild(copyButton);
    
    XtSetArg(resources[n], XmNlabelString, STRING("Clear")); ++n;
    Widget clearButton = XmCreatePushButtonGadget(
		rc, (char *)"clear", resources, n); 
    n = 0;
    XtAddCallback(clearButton, XmNactivateCallback,
		  clearCallback, (XtPointer)examViewer);
    XtManageChild(clearButton);

    XtSetArg(resources[n], XmNlabelString, STRING("About...")); ++n;
    Widget aboutButton = XmCreatePushButtonGadget(
		rc, (char *)"about", resources, n); 
    n = 0;
    XtAddCallback(aboutButton, XmNactivateCallback,
		  showAboutDialog, NULL);
    XtManageChild(aboutButton);

    XtSetArg(resources[n], XmNlabelString, STRING("Quit")); ++n;
    Widget quitButton = XmCreatePushButtonGadget(
		rc, (char *)"quit", resources, n); 
    n = 0;
    XtAddCallback(quitButton, XmNactivateCallback,
		  quitCallback, NULL);
    XtManageChild(quitButton);
    
    XtManageChild(rc);
    XtManageChild(form);

    examViewer->viewAll();
    SoXt::show(w);
    SoXt::mainLoop();
    SoXt::finish();

    return 0;  // Keep C++ from complaining...
}


