//!oiv_include <Inventor/oivShaderState.h>

//!oiv_include <Inventor/oivDepthPeeling_frag.h>

// Anisotropic lighting
uniform float     RGBScale;
uniform sampler2D diffuseMap;
in vec2      texCoord;

// Reflexion
uniform samplerCube envMap;
in vec4        specularLight;
in vec3        reflectance;

uniform float interpolationValue;

void main()
{
  if (OivDepthPeel(gl_FragCoord.xyz))
  {
    // Anisotropic lighting
    vec4  textureValue = texture(diffuseMap, texCoord);
    float coeff        = RGBScale * textureValue.w;

    vec4  anisotropValue;
    anisotropValue.xyz = textureValue.xyz * coeff;
    anisotropValue.w   = 1.;

    // Reflexion
    vec4  reflectedColor = texture(envMap, reflectance);
    float irradiance     = reflectedColor.w;
  
    // Compute final color
    vec4 color   = mix(anisotropValue, reflectedColor, interpolationValue) + specularLight * irradiance;
    color.w = 1.0;
    OivDepthPeelingOutputColor(color);
  }
}
