//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>

uniform mat4 ModelToWC;
uniform vec3 EyePosition;

out vec2 texCoord;
out vec4 specularLight;
out vec3 reflectance;

void main()
{
  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();
  
  // World coordinates
  vec4 positionWC = ModelToWC * vec4(OivVertexPosition().xyz, 1.0);
  vec4 normalWC   = normalize(ModelToWC * vec4(OivVertexNormal(), 0.0));

  // ANISOTROPIC LIGHT
  // Vector pointing from vertex to eye
  vec4 vertToEye = normalize(vec4(EyePosition.xyz, 1.0) - positionWC);
  // Half-angle vector
  vec4 L = normalize(vec4(EyePosition, 1.0));
  vec4 H = normalize(L + vertToEye);
  
  texCoord.x = max(dot(L, normalWC), 0.0);
  texCoord.y = max(dot(H, normalWC), 0.5);
  
  // REFLECTION
  vec3 I = vec3(positionWC) - EyePosition;
  // Normal in world space
  reflectance = reflect(I, vec3(normalWC));
  // Calculate the specular lighting
  vec3 V        = normalize(-I);
  vec3 H2       = normalize(reflectance + V);
  float specLight = pow(max(dot(vec3(normalWC), H2), 0.), OivFrontMaterialShininess());
  specularLight = vec4(specLight, specLight, specLight, specLight);
}

