//!oiv_include <Inventor/oivShaderState.h>

//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

// Available texturing modes are :
#define OBJECT_LINEAR  1
// and default for any other value

//uniform int   texGenMode;
uniform vec3  EyePosition;       // Eye position in world space
uniform mat4  ModelToWC;         // Modeling matrix (object to world space)
uniform int   texGenMode;
uniform int   envMapUnit;        // environment cube map texture unit

// Bump-mapping
out vec3 eNormal;       // Normal in eye space
out vec3 eLightv;       // Vertex to light vector in eye space
out vec3 wReflectance;  // Reflected ray direction in world space
out vec3 wIncident;     // Incident ray direction in world space
out vec4 constColor;    // Non-bumpmapping dependent color (emissive and ambient)

void main()
{
  // Output vertex position
  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();

  vec4 ePosition      = OivModelViewMatrix() * OivVertexPosition();   // Position in eye space
  vec4 eLightPosition = OivLightSourcePosition(0);       // Light position in eye space
       eNormal        = OivNormalMatrix() * OivVertexNormal();      // Normal in eye space
       eLightv        = vec3(eLightPosition - ePosition); // Vertex to light vector in eye space

  // Reflection computations
  vec3 wPosition = mat3(ModelToWC) * OivVertexPosition().xyz;        // Position in world space
  vec3 wNormal   = normalize(mat3(ModelToWC) * OivVertexNormal()); // Normal in world space
       wIncident = wPosition - EyePosition;                // Light to vertex vector in world space
       wReflectance = reflect(wIncident, wNormal);         // Reflected direction in world space
  
  // Material pre-computations
  constColor    = OivFrontMaterialEmissive() 
                + OivFrontMaterialAmbient();

  // Texture Coordinate Generation Computation
  // NVIDIA's bug: the +vec4 is a workaround: when an uniform is only used in an if statement 
  // the compiler wrongly thinks it's an unactive uniform 
  if(texGenMode != OBJECT_LINEAR)
    OivSetTexCoord(0, OivVertexTextureCoordinate(envMapUnit) + vec4(texGenMode,texGenMode,texGenMode,texGenMode));

  if(texGenMode == OBJECT_LINEAR)
  {
    vec2 coord = vec2(dot(OivVertexPosition(), OivObjectPlaneS(0)),  
	                     dot(OivVertexPosition(), OivObjectPlaneT(0)))+
                             vec2(texGenMode,texGenMode)-vec2(texGenMode,texGenMode);
    OivSetTexCoord(0, vec4(coord, 0.0, 0.0));
  }
}
