//!oiv_include <Inventor/oivShaderState.h>

//!oiv_include <Inventor/oivDepthPeeling_frag.h>

uniform float       interpolationValue;
uniform samplerCube envMap;

in vec4 color;
in vec3 reflectance;
in vec4 specularLight;

void main()
{
  if (OivDepthPeel(gl_FragCoord.xyz))
  {
    vec4 reflectedColor = texture(envMap, reflectance);
    float irradiance = reflectedColor.w;
  
    float transp = color.w;
  
    vec4 fColor = color; // writing to in/out variables in a fragment shader is forbidden.
    fColor *=  irradiance;
  
    fColor.w = 0.;
  
    vec4 color = mix(fColor, reflectedColor, interpolationValue) + specularLight * irradiance;
    color.w = transp;
    OivDepthPeelingOutputColor(color);
  }
} 
