//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>

uniform vec3 EyePosition;
uniform mat4 ModelToWC;

out vec4 color;
out vec3 reflectance;
out vec4 specularLight;

void  main()
{
  // Position in clip space
  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();
  
  // Position in world space
  mat3 ModelToWC3 = mat3(ModelToWC[0].xyz, ModelToWC[1].xyz, ModelToWC[2].xyz);
  vec3 positionWC = ModelToWC3 * OivVertexPosition().xyz;
  
  // Normal in world space
  vec3 N = normalize(ModelToWC3 * OivVertexNormal());
  
  vec3 I = positionWC - EyePosition;
  reflectance = reflect(I, N);
  
  const vec3 globalAmbient = vec3(0.2,0.2,0.2);
  
  // Calculate the emissive lighting
  vec3 emissive = OivFrontMaterialEmissive().xyz;
  
  // Calculate the ambient lighting
  vec3 ambient = OivFrontMaterialAmbient().xyz * globalAmbient; 
  
  // Calculate the diffuse lighting
  vec3 diffuse = OivFrontMaterialDiffuse().xyz;
  float diffuseW = OivFrontMaterialDiffuse().w;
  
  // Calculate the specular lighting
  color.xyz = emissive + ambient + diffuse;
  
  //color transparency
  color.w = diffuseW;
  
  // Calculate the specular lighting
  vec3 V      = normalize(-I);
  vec3 H      = normalize(reflectance + V);
  float specL = pow(max(dot(N, H), 0.), OivFrontMaterialShininess());
  specularLight = vec4(specL, specL, specL, specL);
}
