//!oiv_include <Inventor/oivShaderState.h>

//!oiv_include <Inventor/oivDepthPeeling_frag.h>

uniform samplerCube envMap;

in vec4 reflexionFactor;
in vec3 reflectance;
in vec4 specularLight;
in vec3 Tr;
in vec3 Tg;
in vec3 Tb;

void  main()
{
  if (OivDepthPeel(gl_FragCoord.xyz))
  {
    vec4 reflectedColor = texture(envMap, reflectance);
    vec4 refractedColor;
  
    float irradiance = reflectedColor.w;
  
    reflectedColor.w =1.0;
  
    refractedColor.r = texture(envMap, Tr).r;
    refractedColor.g = texture(envMap, Tg).g;
    refractedColor.b = texture(envMap, Tb).b;
    refractedColor.a =1.0;
  
    vec4 color = mix(refractedColor, reflectedColor, reflexionFactor) + specularLight * 0.1;
    OivDepthPeelingOutputColor(color);
  }
} 
