//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>

uniform mat4  ModelToWC;
uniform vec3  EyePosition;
uniform float deltaRGB;

out vec4 reflexionFactor;
out vec3 reflectance;
out vec4 specularLight;
out vec3 Tr;
out vec3 Tg;
out vec3 Tb;

vec3 refract(vec3 I, vec3 N, float etaRatio)
{
  float cosI = dot(-I, N);
  float cosT2 = 1.0 - etaRatio * etaRatio * (1.0 - cosI * cosI);
  vec3 T = etaRatio * I + ((etaRatio * cosI - sqrt(abs(cosT2))) * N);
  return (T * vec3(cosT2 > 0.));
}

// Main function
void main()
{
  // Position in clip space
  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();
  
  // Position in world space
  vec3 positionWC = vec3(ModelToWC * OivVertexPosition());
  
  // Normal in world space
  vec3 normal = mat3(ModelToWC[0].xyz, ModelToWC[1].xyz, ModelToWC[2].xyz) * OivVertexNormal();
  vec3 N = normalize(normal);
  vec3 I = positionWC - EyePosition;
  
  vec3 incidentVec = normalize(I);
  
  reflectance = reflect(incidentVec, N);
  
  // Calculate the specular lighting
  vec3 V = normalize(-I);
  vec3 H = normalize(reflectance + V);
  float specLight = pow(max(dot(N, H), 0.), OivFrontMaterialShininess());
  specularLight = vec4(specLight, specLight, specLight, specLight);

  float refFactor = 0.1 + pow(1. + dot(incidentVec,N),2.0) * 2.0;  
  reflexionFactor = vec4(refFactor, refFactor, refFactor, refFactor);
  
  //float delta = -0.02;
  Tr = refract(incidentVec, N, 1.1);
  Tg = refract(incidentVec, N, 1.1 + deltaRGB);
  Tb = refract(incidentVec, N, 1.1 + (2.0 * deltaRGB));
}
