//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>

uniform vec3  EyePosition;
uniform mat4  ModelToWC;
uniform float	Time;
uniform float	freq;
uniform float	scale;

out vec4 color;
out vec3 reflectance;
out vec4 specularLight;

void main()
{
  // Position in world space
  vec3 positionWC = (ModelToWC * OivVertexPosition()).xyz;
  
  // Normal in world space
  vec3 normal = mat3(ModelToWC[0].xyz, ModelToWC[1].xyz, ModelToWC[2].xyz) * OivVertexNormal();
  vec3 N      = normalize(normal);
  
  vec3 I = positionWC - EyePosition;
  reflectance = reflect(I, normalize(N));
		
  const vec3 globalAmbient = vec3(0.2,0.2,0.2);
  
  // Calculate the emissive lighting
  vec3 emissive = vec3(OivFrontMaterialEmissive());
  
  // Calculate the ambient lighting
  vec3 ambient = OivFrontMaterialAmbient().xyz * globalAmbient; 
  
  // Calculate the diffuse lighting
  vec3 diffuse = OivFrontMaterialDiffuse().xyz;
  float diffuseW = OivFrontMaterialDiffuse().w;
  
  // Calculate the specular lighting
  color.xyz = emissive + ambient + diffuse;
  
  //color transparency
  color.w = diffuseW;

  // Calculate the specular lighting
  vec3 V      = normalize(-I);
  vec3 H      = normalize(reflectance + V);
  float specLight = pow(max(dot(N, H), 0.), OivFrontMaterialShininess());
  specularLight = vec4(specLight, specLight, specLight, specLight);
  
  float displacement = scale * sin(OivVertexPosition().y + Time * freq);
  
  if(displacement < 0.)
    displacement = -displacement;
  
  vec4 dir = vec4(OivVertexNormal().xyz, 0.);
  
  vec4 newPos = OivVertexPosition() + displacement * dir;
  
  gl_Position = OivModelViewProjectionMatrix() * newPos;
}
