//!oiv_include <Inventor/oivShaderState.h>

//!oiv_include <Inventor/oivDepthPeeling_frag.h>

in float diffuseLight;
in float specularLight;
in float edge;
in vec4 diffuseColor;
in vec4 specularColor;

// We don't need that uniform to be given by the API.
// By default, uniform are initialised to 0. It's what we want here.
uniform sampler2D ramp;

void main()
{
  if (OivDepthPeel(gl_FragCoord.xyz))
  {
    // Create the texCoords  
    vec2 texCoordDiffuse  = vec2(diffuseLight, 0);
    vec2 texCoordSpecular = vec2(specularLight, 0);
    vec2 texCoordEdge     = vec2(edge, 0);
  
    // Writing to in/out variables is forbidden, so we copy some of them.
    float fDiffuseLight  = diffuseLight;
    float fSpecularLight = specularLight;
    float fEdge          = edge;
    fDiffuseLight  = texture(ramp, texCoordDiffuse).x;
    fSpecularLight = texture(ramp, texCoordSpecular).x;
    fEdge          = texture(ramp, texCoordEdge).x;
  
    // Compute the final color
    vec4 color   = fEdge * (diffuseColor*fDiffuseLight + specularColor*fSpecularLight);
    color.w = 1.0;
    OivDepthPeelingOutputColor(color);
  }
} 
