/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM 2004)
**=======================================================================*/

#include "auditors.h"

#include <Inventor/actions/SoWriteAction.h>
#include "dialog.h"
#include "misc.h"
#include "model.h"
#include "shaders.h"
#include "materialEditor.h"
#include "main.h"

/****************************************************************************/
// Select a shader file, load the corresponding shader and insert it into
// the scene graph
void 
ChangeShaderButtonAuditor::menuFileSelection(SoMenuFileSelection * cpt)
{
  // Select the shader file
  SbString filename =  cpt->fileDirectory.getValue() ;
           filename += "/" ;
           filename += cpt->filename.getValue();
  if(!filename) {
#if defined(_DEBUG)
    SoDebugError::postWarning("ChangeShaderButtonAuditor::menuPushButton",
                              "No shader file has been selected (user-cancelled load ?).");
#endif
    return;
  }
  
  // Extract the shader graph from the file
  SoSeparator * shader = readFile(filename);
  if(!shader) {
#if defined(_DEBUG)
    SoDebugError::post("ChangeShaderButtonAuditor::menuPushButton",
                       "No shader graph could be extracted from the file %s.", filename.getString());
#endif
    return;
  }

  if(!isValidShader(shader)) {
#if defined(_DEBUG)
    SoDebugError::post("ChangeShaderButtonAuditor::menuPushButton",
                       "The graph extracted from the file %s is not a valid shader.", filename.getString());
#endif
    return;
  }

  shaderInit(shader, (char *)filename.getString());
  centerModel();
}//---------------------------------------------------------------------------

/****************************************************************************/
// Select a model file, load the corresponding graph and insert it into
// the scene graph
void 
ChangeModelButtonAuditor::menuFileSelection(SoMenuFileSelection * cpt)
{
  // Select the model file
  SbString filename =  cpt->fileDirectory.getValue() ;
           filename += "/" ;
           filename += cpt->filename.getValue();

  if(!filename) {
    return;
  }
  
  // Extract the model graph from the file
  SoSeparator * newModel = readFile(filename);
  if(!newModel) {
#if defined(_DEBUG)
    SoDebugError::post("ChangeModelButtonAuditor::menuPushButton",
                       "No shader graph could be extracted from the file %s.", filename.getString());
#endif
    return;
  }
  
#if defined(_DEBUG)
  if(isValidShader(newModel, FALSE)) {
    SoDebugError::
      postWarning("ChangeModelButtonAuditor::menuPushButton",
                  "Make sure you haven't selected a SHADER file instead of a MODEL file.");
  }
#endif
  
  changeModel(getSceneSep(), newModel);
}//---------------------------------------------------------------------------

/****************************************************************************/
// Auditor for the Write Button
// This button writes the current scene in the OUTPUT_FILENAME file
void 
WriteButtonAuditor::menuPushButton(SoMenuPushButton* /*pb*/) {
  SoWriteAction myAction;
  myAction.getOutput()->openFile(OUTPUT_FILENAME);
  myAction.getOutput()->setBinary(FALSE);
  myAction.apply(getRoot());
  myAction.getOutput()->closeFile();
}//---------------------------------------------------------------------------

/****************************************************************************/
// Exit the application
void 
ExitButtonAuditor::menuPushButton(SoMenuPushButton* /*cpt*/)
{
  exit(EXIT_SUCCESS);
}//---------------------------------------------------------------------------

/****************************************************************************/
// Show or hide the shader dialog components
void 
ShowDialogButtonAuditor::menuCheckBox(SoMenuCheckBox * cpt)
{
  if(cpt->state.getValue())
    showShaderTabDialog();
  else
    hideShaderTabDialog();
}//---------------------------------------------------------------------------

/****************************************************************************/
// Indicates if the material editor button shall produce an action or not
void 
ShowMaterialEditorButtonAuditor::menuCheckBox(SoMenuCheckBox * cpt)
{
  setMaterialEditorShowable(cpt->state.getValue());
}//---------------------------------------------------------------------------

/****************************************************************************/
// Attachs the right SoMaterial node to the MaterialEditor 
void 
MaterialEditorChoiceAuditor::dialogChoice(SoDialogChoice* /*cpt*/)
{
  setMaterialToAttach(getLastMaterialNode());
  attachMaterialEditor();
}//---------------------------------------------------------------------------


