/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM 2004)
**=======================================================================*/

#ifndef _SHADERS_BROWSER_DIALOG_H_
#define _SHADERS_BROWSER_DIALOG_H_

#include <DialogViz/SoDialogVizAll.h>

#define DIALOGPART_NAME     "DialogPart"
#define TITLE               "Shaders Browser"
#define MATERIAL_AUDITOR_ID "materialEditor"
#define ERROR_TITLE         "Shaders Browser - Warning"

#define DIALOG_COMPONENTS_MAX_WIDTH 350
#define DIALOG_COMPONENTS_MIN_WIDTH 150

void               setTitleBar(SbString title = "");
Widget             getSceneWidget();
void               resetShaderTabDialog();
void               setShaderIVFileContent(SoSeparator * shader, SbString filename);
SoTopLevelDialog * initDialog();
void               addShaderObjectSourceFile(SbString filename, SbString sourceProgram);
void               addParamControl(SoDialogComponent * slider);
void               showShaderTabDialog();
void               hideShaderTabDialog();
void               setMaterialEditorCheckboxState(SbBool val);
void               setMaterialEditorCheckboxEnablement();
void               errorMessageDialog(SbString message);

#endif //_SHADERS_BROWSER_DIALOG_H_


