/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM 2004)
**=======================================================================*/

#include "environment.h"

#include <Inventor/nodes/SoComplexity.h> 
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/nodes/SoScale.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTextureCoordinate2.h>

/****************************************************************************/
// Returns the environment of the scene i.e. a correct texture cube map.
SoSeparator * 
loadEnvironment()
{
  SoSeparator * res = new SoSeparator;
  res->ref();
  
  // Complexity
  SoComplexity * comp = new SoComplexity;
  comp->textureQuality = 1.0f;
  res->addChild(comp);
  
  // Scale
  SoScale * scale = new SoScale;
  scale->scaleFactor = SbVec3f(EnvScaleFactor, EnvScaleFactor, EnvScaleFactor);
  res->addChild(scale);
  
  SoTexture2 * envTextureTab[6];
  
  // SoSeparator: 1 for each texture of the cube map
  for(int i=0; i<6; i++) {
    SoSeparator * s = new SoSeparator;
    res->addChild(s);
    
    // Texture coordinate
    SoTextureCoordinate2 * texCoord = new SoTextureCoordinate2;
    texCoord->point.set1Value(EnvTexCoordTab[i][0], SbVec2f(0,0));
    texCoord->point.set1Value(EnvTexCoordTab[i][1], SbVec2f(0,1));
    texCoord->point.set1Value(EnvTexCoordTab[i][2], SbVec2f(1,1));
    texCoord->point.set1Value(EnvTexCoordTab[i][3], SbVec2f(1,0));
    s->addChild(texCoord);
    
    // Initialize texture
    envTextureTab[i] = new SoTexture2;
    envTextureTab[i]->wrapS = SoTexture::CLAMP_TO_EDGE;
    envTextureTab[i]->wrapT = SoTexture::CLAMP_TO_EDGE;
    envTextureTab[i]->model = SoTexture::REPLACE;
    envTextureTab[i]->filename.setValue(EnvTextureName[i]);
    s->addChild(envTextureTab[i]);
    
    // Face set
    SoFaceSet * faceSet = new SoFaceSet;	
    s->addChild(faceSet);
    SoVertexProperty * myVertexProperty = new SoVertexProperty;
    faceSet->vertexProperty.setValue(myVertexProperty);
    faceSet->numVertices.setValues(0, 1, NumEnvVertices[i]);
    myVertexProperty->vertex.setValues(0,4,EnvVertices[i]);
  }
  
  return res;
}//---------------------------------------------------------------------------


