/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM 2004)
**=======================================================================*/

#ifndef _SHADERS_BROWSER_ENVIRONMENT_H_
#define _SHADERS_BROWSER_ENVIRONMENT_H_

#include <Inventor/nodes/SoSeparator.h>

/****************************************************************************/
// Returns the environment of the scene i.e. a correct texture cube map.
SoSeparator * loadEnvironment();

const float EnvScaleFactor = 400;

const int EnvTexCoordTab[6][4] = {
  {1, 0, 3, 2}, 
  {1, 0, 3, 2}, 
  {1, 0, 3, 2},	
  {0, 3, 2, 1}, 
  {0, 3, 2, 1}, 
  {3, 2, 1, 0}
};

const int32_t NumEnvVertices[6][1] = { 
  {4}, {4}, {4}, {4}, {4}, {4}
};

const float 
EnvVertices[6][4][3] ={
  {{ 1, -1, -1}, { 1,  1, -1}, {-1,  1, -1}, {-1, -1, -1}}, 
  {{ 1, -1,  1}, { 1,  1,  1}, { 1,  1, -1}, { 1, -1, -1}},
  {{-1, -1,  1}, {-1,  1,  1}, { 1,  1,  1}, { 1, -1,  1}},
  {{-1,  1, -1}, {-1,  1,  1}, {-1, -1,  1}, {-1, -1, -1}},	
  {{-1, -1,  1}, { 1, -1,  1}, { 1, -1, -1}, {-1, -1, -1}},
  {{ 1,  1, -1}, { 1,  1,  1}, {-1,  1,  1}, {-1,  1, -1}}
};

const char EnvTextureName[6][200] = {
  {"$OIVHOME/examples/source/Inventor/ShadersBrowser/Textures/z-.png"},
  {"$OIVHOME/examples/source/Inventor/ShadersBrowser/Textures/x+.png"},
  {"$OIVHOME/examples/source/Inventor/ShadersBrowser/Textures/z+.png"},
  {"$OIVHOME/examples/source/Inventor/ShadersBrowser/Textures/x-.png"},
  {"$OIVHOME/examples/source/Inventor/ShadersBrowser/Textures/y-.png"},
  {"$OIVHOME/examples/source/Inventor/ShadersBrowser/Textures/y+.png"}
};

#endif //_SHADERS_BROWSER_ENVIRONMENT_H_

