/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM 2004)
**=======================================================================*/

#include "materialEditor.h"

#include <Inventor/Xt/SoXtMaterialEditor.h> 
#include "dialog.h"

SoXtMaterialEditor * MaterialEditor            = NULL;
SoMaterial         * MaterialToAttach          = NULL;
// CanBeShown indicates if the user wants the material editor to be shown 
// (typically by checking it or de-checking it in the menu bar). However,
// the Material Editor can still be hidden although CanBeShown is set to 
// TRUE if the Material Editor acts on nothing (not attached)) and, 
// consequently, is useless at the current time.
SbBool               CanBeShown                = FALSE;

/****************************************************************************/
// Hide the material editor window
void
hideMaterialEditor()
{
  if(MaterialEditor) {
    MaterialEditor->hide();
  }
#if defined(_DEBUG)
  else {
    SoDebugError::post("hideMaterialEditor", "MaterialEditor is NULL.");
  }
#endif
  // uncheck the 'Material Editor' option in the menu bar
  setMaterialEditorCheckboxState(FALSE);
}//---------------------------------------------------------------------------

/****************************************************************************/
// Show the material editor window
void
showMaterialEditor()
{
  if(CanBeShown && MaterialEditor && MaterialEditor->isAttached()) {
    MaterialEditor->show();
    setMaterialEditorCheckboxState(TRUE);
  }
#if defined(_DEBUG)
  else {
    if(!MaterialEditor) {
      SoDebugError::post("showMaterialEditor", "MaterialEditor is NULL.");
    }
    else if(!MaterialEditor->isAttached()) {
      SoDebugError::post("showMaterialEditor", "MaterialEditor is not attached.");
    }
  }
#endif
}//---------------------------------------------------------------------------

/****************************************************************************/
// Callback when the user closes the Material Editor window
void
checkMaterialEditorVisibilityCB(void *, SoXtComponent *)
{
  hideMaterialEditor();
}//---------------------------------------------------------------------------

/****************************************************************************/
// Initialization of the material editor
void
initMaterialEditor()
{
  MaterialEditor = new SoXtMaterialEditor;
  MaterialEditor->setWindowCloseCallback (checkMaterialEditorVisibilityCB);
}//---------------------------------------------------------------------------

/****************************************************************************/
// Attach the material editor
void
attachMaterialEditor()
{
  if(MaterialToAttach && MaterialEditor) {
    MaterialEditor->attach(MaterialToAttach);
  }
#if defined(_DEBUG)
  else {
    if(!MaterialToAttach)
      SoDebugError::post("attachMaterialEditor", "The Material to attach is NULL.");
    if(!MaterialEditor)
      SoDebugError::post("attachMaterialEditor", "The attaching MaterialEditor is NULL.");
  }
#endif
}//---------------------------------------------------------------------------

/****************************************************************************/
// Sets the current material node to attach
void
setMaterialToAttach(SoMaterial * node)
{
  MaterialToAttach = node;
#if defined(_DEBUG)
  if(!node) {
    SoDebugError::post("setMaterialToAttach", "The material to attach is NULL");
  }
#endif
}//---------------------------------------------------------------------------

/****************************************************************************/
// Resets the material editor
void
resetMaterialEditor()
{
  if(MaterialEditor) {
    MaterialEditor->detach();
    MaterialToAttach = NULL;
    hideMaterialEditor();
  }
#if defined(_DEBUG)
  else {
    SoDebugError::post("resetMaterialEditor", "MaterialEditor is NULL.");
  }
#endif
}//---------------------------------------------------------------------------

/****************************************************************************/
// Switch between show and hide the Material Editor according 
void
setMaterialEditorShowable(SbBool newVal)
{
  CanBeShown = newVal;
  if(newVal) {
    showMaterialEditor();
  }
  else {
    hideMaterialEditor();
  }
}//---------------------------------------------------------------------------

/****************************************************************************/
// 
SbBool
isMaterialEditorAttached()
{
  if(!MaterialEditor) {
#if defined(_DEBUG)
    SoDebugError::post("isMaterialEditorAttached", "MaterialEditor is NULL.");
#endif
    return FALSE;
  }
  return MaterialEditor->isAttached();
}//---------------------------------------------------------------------------


