/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM 2004)
**=======================================================================*/

#include "misc.h"

#include <Inventor/Xt/SoXtFileSelectionDialog.h> 

/****************************************************************************/
// This function returns just the filename targeted by the given full path.
// For example, removeDirectories("rep1/rep2/rep3/file.txt")
// shall return "file.txt".
SbString
removeDirectories(SbString path)
{
  int strlen = path.getLength();
  int resBegin = 0;
  
  for(int i=0; i<strlen; i++) {
    if(path.getSubString(i, i) == "\\" || path.getSubString(i, i) == "/") {
      if(i+1 < strlen - 1) {
        resBegin = i+1;
      }
    }
  }
  return path.getSubString(resBegin, -1);
}
//----------------------------------------------------------------------------

/****************************************************************************/
// Extract a graph from the given file
SoSeparator *
readFile(SbString filename)
{
  SoInput MyInput;
  
  if(!filename)
    return NULL;
  
  if(!MyInput.openFile(filename.getString())) {
#if defined(_DEBUG)
    SoDebugError::post("readFile", "Failure when opening the file %s.", filename.toLatin1());
#endif
    return NULL;
  }
  
  SoSeparator * res = (SoSeparator *)SoDB::readAll(&MyInput);
  MyInput.closeFile();
  
  return res;
}//---------------------------------------------------------------------------

/****************************************************************************/
// Open a file selection dialog and returns the selected file.
SbString
fileSelection(char * dirname, char * description)
{
  SoXtFileSelectionDialog fd;
  
  fd.setFileDirectory(dirname);
  fd.setFilter((char*)"iv", description);
  fd.show();
  const char * filename = fd.getFileName();
  
  if(filename == NULL) //typically 'Cancel'
    return SbString("");
  
  return SbString(filename);
}//---------------------------------------------------------------------------


