/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM 2004)
**=======================================================================*/

#include "model.h"

#include <Inventor/actions/SoGetBoundingBoxAction.h>
#include "shaders.h"
#include "environment.h"
#include "misc.h"

#define SCALE_FACTOR 0.5f

SbVec3f	      ModelPosition(0, 0, 0);
SoTransform	* ModelTransform;

/****************************************************************************/
// Center the model
void 
centerModel()
{
  SbViewportRegion vp;
  SoGetBoundingBoxAction bbAction(vp);

  SoSeparator * temp = (SoSeparator *)SoNode::getByName(MODELSEP_NAME);
  if(!temp) {
    return;
  }
  
  bbAction.apply((SoNode *)temp);
  SbBox3f bb = bbAction.getBoundingBox();
  
  SbVec3f bbSize = bb.getMax() - bb.getMin();

  float maxModelSize = ((bbSize[0]    > bbSize[1]) ? bbSize[0]    : bbSize[1]) ;
        maxModelSize = ((maxModelSize > bbSize[2]) ? maxModelSize : bbSize[2]) ;
  float scaleFactor  = ( EnvScaleFactor / maxModelSize ) * SCALE_FACTOR ;

  // Recale and translate the model
  ModelTransform->scaleFactor.setValue(scaleFactor, scaleFactor, scaleFactor) ;
  
  // Model translation
  // center in 0
  ModelTransform->translation.setValue(-bb.getCenter()*scaleFactor);
  
  updateModelingMatrixParam(vp, ModelTransform);
}//---------------------------------------------------------------------------

/****************************************************************************/
// change the current model
void
changeModel(SoSeparator * sceneSep, SoSeparator * newModel)
{
  if(!newModel) {
#if defined(_DEBUG)
    SoDebugError::post("changeModel", "Failure when accessing the new model");
#endif
    return;
  }

#if defined(_DEBUG)
  if(isValidShader(newModel, FALSE)) {
    SoDebugError::postWarning("changeModel", 
    "The model contains characteristic nodes of a shader.\n\
    You may have loaded a *SHADER* instead of a *MODEL* file.");
  }
#endif
  
  SoSeparator * oldModel = (SoSeparator *)sceneSep->getByName(MODELSEP_NAME);
  if(!oldModel) {
#if defined(_DEBUG)
    SoDebugError::post("changeModel", "Failure when searching the previous model.");
#endif
    return;
  }
  newModel->setName(MODELSEP_NAME);
  sceneSep->replaceChild(oldModel, newModel);
  centerModel();
}//---------------------------------------------------------------------------

/****************************************************************************/
// load the model
SoSeparator * 
loadModel(SbString modelname)
{
  SoSeparator * modelSep = new SoSeparator;
  modelSep->ref();
  
  // Transfor: translation + scale
  ModelTransform = new SoTransform;
  ModelTransform->translation.setValue(ModelPosition);
  modelSep->addChild(ModelTransform);
  
  SoSeparator * model = new SoSeparator;
  model->setName(MODELSEP_NAME);
  modelSep->addChild(model);
  
  changeModel(modelSep, readFile(modelname));
  
  return modelSep;
}//---------------------------------------------------------------------------

