
#include "SbShaderTutorialViewer.h"

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoSeparator.h>

#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoDialogViz.h>

#define ENABLE_LIGHT_EDITOR 0

void
SbShaderTutorialViewer::init()
{
  m_window = SoXt::init("ShaderTutorialViewer");
  SoDialogViz::init();
}

void
SbShaderTutorialViewer::open(const char* filename)
{
  SoInput input;
  //input.addDirectoryFirst("$OIVHOME/examples/source/Inventor/ShadersTutorial/data");
  input.openFile(filename);

  SoSeparator* iv = SoDB::readAll(&input);

  SoTopLevelDialog* gui = static_cast<SoTopLevelDialog*>(iv->getByName("GUI"));
  gui->buildDialog(m_window, true);

  SoWidget viewerWidget = static_cast<SoDialogCustom*>(iv->getByName("VIEWER"))->getWidget();
  m_viewer = new SoXtExaminerViewer(viewerWidget);

  SoSeparator* scene = static_cast<SoSeparator*>(iv->getByName("SCENE"));
  m_viewer->setSceneGraph(scene);
  m_viewer->setHeadlight(false);
  m_viewer->show();
  m_viewer->viewAll();

#if ENABLE_LIGHT_EDITOR
  // add light editor if needed
  SoSearchAction sa;
  sa.setType(SoDirectionalLight::getClassTypeId());
  sa.setSearchingAll(true);
  sa.setInterest(SoSearchAction::ALL);
  sa.apply(m_viewer->getSceneManager()->getSceneGraph());
  SoPathList pathList = sa.getPaths();
  for (int i = 0; i < pathList.getLength(); ++i)
  {
    SoXtDirectionalLightEditor* le = new SoXtDirectionalLightEditor;
    le->setTitle(SbString("Light") + i);
    le->attach(pathList[i]);
    le->show();
    m_lightEditor.push_back(le);
  }
#endif
}

void
SbShaderTutorialViewer::show()
{
  SoXt::show(m_window);
  SoXt::mainLoop();
}

void
SbShaderTutorialViewer::finish()
{
  for (unsigned i = 0; i < m_lightEditor.size(); ++i)
    delete m_lightEditor[i];

  delete m_viewer;

  SoDialogViz::finish();
  SoXt::finish();
}
