#ifndef SB_SHADER_TUTORIAL_VIEWER_H
#define SB_SHADER_TUTORIAL_VIEWER_H

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/SoXtDirectionalLightEditor.h>

// Helper class to load an iv file in a viewer
class SbShaderTutorialViewer
{
public:

  // initialize viewer
  void init();

  // open an iv file
  void open(const char* filename);

  // run rendering loop
  void show();

  // clean and finalize
  void finish();

protected:

  SoWidget m_window;
  SoXtExaminerViewer* m_viewer;
  std::vector<SoXtDirectionalLightEditor*> m_lightEditor;
};


#endif // SB_SHADER_TUTORIAL_VIEWER_H
