#version 410 core

//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>


// uniform parameter
uniform float gamma;

// input parameter from vertex shader
in vec3 vColor;


// gamma func with a modified paramater
void
gammaCorrection ( inout vec3 color )
{
  // powerify the color
  color = pow(color, vec3(gamma));
}

// main func
void
main ()
{
  // get the color
  vec3 color = vColor;

  // apply gamma correction
  gammaCorrection(color);

  // write into the framebuffer
  OivFragmentOutput(vec4(color, 1.0));
}


