#version 410 core

//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>


// pre-processor param
#define PI 3.14159265

// uniform parameter
uniform float freqFactor;

// output parameter to fragment shader
out vec3 vColor;


// displacement function with a read-only parameter
vec3
displace ( in vec3 p )
{
  // compute delta
  float delta = cos(p.x*freqFactor*PI)*sin(p.y*freqFactor*PI)*cos(p.z*freqFactor*PI);

  // apply transformation along the normal
  return 0.5*(p + smoothstep(0.0, 1.0, abs(delta)) * normalize(p));
}

// main func
void
main ()
{
  // transform the position into a color
  vColor = 0.5*OivVertexPosition().xyz + 0.5;

  // apply displacement
  vec3 vPos = displace(OivVertexPosition().xyz);

  // transform into screen space coordinates
  gl_Position = OivModelViewProjectionMatrix() * vec4(vPos, 1.0);
}
