#version 410 core

//!oiv_include <Inventor/oivShaderState.h>


// configure the number of vertices per patch
layout(vertices = 4) out;

// tessellation uniform parameters
uniform float TessLevelInner;
uniform float TessLevelOuter;

// input normals from vertex shaders (size = 4)
in vec3 vNormal[];

// output normals to tessellation evaluation shader (size = 4)
out vec3 tcNormal[];

// define the ID of the current invocation (ID in [0;3])
#define ID gl_InvocationID

// the main
void
main()
{
  // fill the position to interpolate
  gl_out[ID].gl_Position = gl_in[ID].gl_Position;
  
  // the same for normals
  tcNormal[ID] = vNormal[ID];
  
  // fix the tessellation levels
  if (ID == 0)
  {
    gl_TessLevelInner[0] = TessLevelInner;
    gl_TessLevelInner[1] = TessLevelInner;
    gl_TessLevelOuter[0] = TessLevelOuter;
    gl_TessLevelOuter[1] = TessLevelOuter;
    gl_TessLevelOuter[2] = TessLevelOuter;
    gl_TessLevelOuter[3] = TessLevelOuter;
  }
}
