#version 410 core

//!oiv_include <Inventor/oivShaderState.h>


// tessellation config
layout(quads, equal_spacing, ccw) in;

// pre-processor param
#define PI 3.14159265

// uniform parameter
uniform float freqFactor;

// normals from tessellation control shader invocations
in vec3 tcNormal[];

// output normal to fragment shader
out vec3 teNormal;

// output color to fragment shader
out vec3 teColor;

// displacement function with a read-only parameter
vec3
displace ( in vec3 p )
{
  // compute delta
  float delta = cos(p.x*freqFactor*PI)*sin(p.y*freqFactor*PI)*cos(p.z*freqFactor*PI);

  // apply transformation along the normal
  return 0.5*(p + smoothstep(0.0, 1.0, abs(delta)) * normalize(p));
}

void
main()
{
  // interpolate the current position
  vec3 p0 = mix(gl_in[0].gl_Position.xyz, gl_in[1].gl_Position.xyz, gl_TessCoord.x);
  vec3 p1 = mix(gl_in[3].gl_Position.xyz, gl_in[2].gl_Position.xyz, gl_TessCoord.x);
  vec3 pos = mix(p0, p1, gl_TessCoord.y);

  // push to sphere
  pos = normalize(pos);
  
  // assign the color and normal
  teColor  = 0.5 * pos + 0.5;
  teNormal = OivNormalMatrix()*tcNormal[0];

  // displace the position
  pos = displace(pos);

  // write the position to output parameter
  gl_Position = OivModelViewProjectionMatrix() * vec4(pos, 1.0);
}
