#version 410 core

//!oiv_include <Inventor/oivShaderState.h>


// configure the number of vertices per patch
layout(vertices = 4) out;

// a uniform parameter
uniform float TessLevel;

// input normals from vertex shaders (size = 4)
in vec3 vNormal[];

// output normals to tessellation evaluation shader (size = 4)
out vec3 tcNormal[];

// define the ID of the current invocation (ID in [0;3])
#define ID gl_InvocationID

// the main
void
main()
{
  // fill the position to interpolate
  gl_out[ID].gl_Position = gl_in[ID].gl_Position;
  
  // the same for normals
  tcNormal[ID] = vNormal[ID];
  
  // fix the tessellation levels
  if (ID == 0)
  {
    gl_TessLevelInner[0] = TessLevel;
    gl_TessLevelInner[1] = TessLevel;
    gl_TessLevelOuter[0] = TessLevel;
    gl_TessLevelOuter[1] = TessLevel;
    gl_TessLevelOuter[2] = TessLevel;
    gl_TessLevelOuter[3] = TessLevel;
  }
}
