#version 410 core
//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

// uniform parameters
uniform int numLight;

uniform float Ka;
uniform float Kd;
uniform float Ks;
uniform float shininess;

// input parameter from Tessellation evaluation shader
in vec3 teEyeDir;
in vec3 teNormal;
in vec3 teColor;


// shade it with 'n', the normal, 'v', the view direction, 'l', the light direction
// and c, the surface color. All directions must be normalized
vec3
phongShading ( in vec3 n, in vec3 v, in vec3 l, in vec3 c )
{ 
    // n dot l
  float NdL = max(dot(n, l), 0.0);

  // specular reflection
  vec3 r = reflect(-l, n);
  float specular = pow( max(dot(r, v), 0.0), shininess );

  // final composition
  return min((Ka + Kd*NdL)*c + Ks*specular, 1.0);
}


// shade it with 'n', the normal, 'v', the view direction, 'l', the light direction
// and c, the surface color. All directions must be normalized
vec3
goochShading ( in vec3 n, in vec3 v, in vec3 l, in vec3 c )
{
  vec3 WarmColor = vec3(0.8, 0.6, 0.0);
  vec3 CoolColor = vec3(0.0, 0.0, 0.6);
  
  // n dot l
  float NdL = (dot(n, l) + 1.0)*0.5;
    
  // interpolate color
  vec3 kcool    = min(CoolColor + 0.25 * c, 1.0);
  vec3 kwarm    = min(WarmColor + 0.25 * c, 1.0); 
  vec3 kfinal   = mix(kcool, kwarm, NdL);

  // specular reflection
  vec3 r = reflect(-l, n);
  float specular = pow( max(dot(r, v), 0.0), shininess );
  
  // final composition
  return min(kfinal + specular, 1.0);
}


// Transform RGB color to YUV
vec3
rgb2yuv ( in vec3 rgb )
{
  mat3 m = mat3( vec3(0.299, -0.14713, 0.615),
           vec3(0.587, -0.28886, -0.51499),
           vec3(0.114, 0.436, -0.10001) );
  
  return m*rgb;
}


// Transform YUV color to RGB
vec3
yuv2rgb ( in vec3 yuv )
{
  mat3 m = mat3( vec3(1.0),
                 vec3(0.0, -0.39465, 2.03211),
                 vec3(1.13983, -0.58060, 0.0) );
  
  return m*yuv;
}

vec3
toneMapping ( in vec3 color, in float maxIntensity )
{
  vec3 yuv = rgb2yuv(color);
  yuv[0] = (log(1.0 + yuv[0]) / log(10)) / (log(1.0 + maxIntensity) / log(10));
  return yuv2rgb(yuv);             
}

// main func
void
main ()
{
  // the directions
  vec3 n = normalize(teNormal);
  vec3 v = normalize(teEyeDir);
  vec3 c = vec3(1.0);

  // shading
  vec3 color = vec3(0.0);
  for ( int i = 0; i < numLight; ++i ) {
    vec3 l = normalize(OivLightSourcePosition(i).xyz);
    
    // use either phong shading ...
    color += phongShading(n, v, l, c)*OivLightSourceDiffuse(i).rgb;
    
    // or gooch shading
    //color += goochShading(n, v, l, c)*OivLightSourceDiffuse(i).rgb;
  }
  
  // tone mapping
  color = toneMapping(color, numLight);
  
  OivFragmentOutput(vec4(color, 1.0));
}





