#version 410 core

//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

// uniform parameters
uniform sampler2D colorMap;

uniform float Ka;
uniform float Kd;
uniform float Ks;
uniform float shininess;

// input parameters from Tessellation evaluation shader
in vec3 tePos;
in vec3 teEyeDir;
in vec3 teNormal;
in vec2 teTexCoord;


// shade it with 'n', the normal, 'v', the view direction, 'l', the light direction
// and c, the surface color. All directions must be normalized
vec3
phongShading ( in vec3 n, in vec3 v, in vec3 l, in vec3 c )
{ 
    // n dot l
  float NdL = max(dot(n, l), 0.0);
      
  // specular reflection
  vec3 r = reflect(-l, n);
  float specular = pow( max(dot(r, v), 0.0), shininess );
  
  // final composition
  return min((Ka + Kd*NdL)*c + Ks*specular, 1.0);
}


// main func
void
main ()
{
  // the directions
  vec3 n = normalize(teNormal);
  vec3 v = normalize(teEyeDir);
  vec3 l = normalize(OivLightSourcePosition(0).xyz);
  vec3 c = texture(colorMap, teTexCoord).rgb;

  // shading
  vec3 color = phongShading(n, v, l, c)*OivLightSourceDiffuse(0).rgb;
  
  // final color
  OivFragmentOutput(vec4(color, 1.0));
}


