/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef  _CURVE_
#define  _CURVE_

#include "Track.h"

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Curve
//
//  A curved section of track
//
//////////////////////////////////////////////////////////////////////////////

class Curve : public TrackSegment
{
    SO_NODE_HEADER(Curve);

  public:
    // Must pass radius/angle to constructor.  See comments before
    // protected radius/angle fields for more info.
    Curve(float r, float a);

    static void		initClass();

    // This is used to link pieces together.  Called by Track.
    // This modifies lastPosition/lastOrientation.
    virtual void link(SbVec3f &lastPosition, SbRotation &lastOrientation,
		      TrackSegment *nextSeg, TrackSegment *prevSeg,
		      int trackID);

    // Given a starting position, a velocity (expressed in
    // track-length units), and a time delta, calculate a new position
    // on the track and the grip at that position.
    void getNewPosition(const TrackPosition &start,
			const TrackPosition &velocity,
			const SbTime &deltaTime,
			TrackPosition &result,
			float &grip);

    // Given a track position, return a world-space position:
    void getWorldPosition(const TrackPosition &position,
			  WorldPosition &result);

    // Given a track position, return the curvature or length at that position
    float getCurvature(const TrackPosition &position);
    float getLength(const TrackPosition &position);

  protected:
    Curve();
    virtual ~Curve();

    // Override read() to setup scene graph:
    virtual SbBool      readInstance(SoInput *in, unsigned short flags);

    // This is called by readInstance or the public constructor to
    // create an appropriate scene graph.
    virtual void	constructSceneGraph();

    // Fields are protected; they must not be changed once a node is
    // read in or constructed.

    // Radius of turn.  The default value of 1.0 actually corresponds
    // to a radius of 100 world-space units.
    // Positive radii correspond to left-hand turns, negative to
    // right-hand turns; if the radius is negative, the turn angle had
    // better be negative, too!
    SoSFFloat radius;

    // Angle of turn, in fractions of 360 degrees.
    // The default value of .25 is a 90 degree turn.
    SoSFFloat angle;
    
  private:
    int			ID;
    TrackSegment *	next;
    TrackSegment *	prev;
    SbVec3f		startPosition;
    SbRotation  	orientation;
    SoTransform *	transform;
};

#endif /* _CURVE_ */


