/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
**=======================================================================*/


#ifndef  _NETWORK_
#define  _NETWORK_

#if defined(_WIN32)
typedef unsigned long u_int32_t;
#endif
#include <stdio.h>
#include <sys/types.h>

#ifndef _WIN32
#  include <sys/socket.h>
#  include <netinet/in.h>
#endif

#include <Inventor/SbBasic.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Struct: NetworkMsg
//
//  All messages will be sent through and received from the socket
//  as class structures derived from this class.
//
//////////////////////////////////////////////////////////////////////////////

class NetworkMsg {
  public:
    NetworkMsg() { fromAddress = 0; gameId = 255; }

    u_int32_t getFromAddress() const { return fromAddress; }

  private:
    // Where this packet came from (Internet address).
    // This info is NOT transmitted across the net.
    u_int32_t	fromAddress;

    // Which game to be part of
    unsigned char	gameId;

friend class Network;
};

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Network
//
//////////////////////////////////////////////////////////////////////////////

class Network {
  public:
    // Constructor creates a multicast socket
    // The gameId is used to distinguish different games, and allows
    // us to use one socket address for a bunch of different games.
    Network(unsigned char _gameId);
    
    // Destructor closes the socket
    ~Network();
    
    // Return the socket file descriptor
    int		getfd() const { return fileDesc; }

    // Send a message on the socket, return TRUE on success.
    SbBool	send(NetworkMsg &msg, int numBytes);

    // Get a message from the socket, or NULL on failure.
    const NetworkMsg *get();
    
  protected:
    // Receive data on the socket from some address.  Maximum message
    // size is hard-coded to 256 characters.
    SbBool	receive(unsigned char *buf, int size);
    
  private:
    unsigned char gameId;
    int	fileDesc;
    struct sockaddr_in  destAddr;    // network address of the mcast group
};

// Choosing this as the gameId will disable sending/receiving stuff
// from the network.
#define DISABLE_NETWORK_GAMEID 101

#endif /* _NETWORK_ */


