/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef  _ROBOT_CAR_
#define  _ROBOT_CAR_

#include "Car.h"
class Track;
class SoSeparator;
class SoTransform;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: RobotCar
//
//  This class defines a robot car used in the slotcar game.  Robot
//  cars are really dumb...
//
//////////////////////////////////////////////////////////////////////////////

class GameState;

class RobotCar : public Car {
 public:
    RobotCar();				// Local robot
    RobotCar(const CarPlayer &);	// Network robot
    ~RobotCar();

    static void	SimulateRobots(GameState *state, const SbTime &);

    SoSeparator *getCarRoot();
    
    void 	setScreechAmount(float amt, float curvature);

    // Add and remove annotation above the car
    virtual void        addAnnotation();
    virtual void        removeAnnotation();

  protected:
    virtual void	positionCar(const WorldPosition &position);
    
 private:
    void buildCar();

    void simulate(GameState *, const SbTime &);
    SbBool changeLanesSafely(GameState *, const SbTime &, int);
    SbBool carAhead(GameState *, const SbTime &,
		    const TrackPosition &, float);

    float skill;  // Fraction, 0.0 to 1.0, of max track velocity
    float maxV;   // Maximum velocity on straight

    SoSeparator *carGraph;
    SoSeparator *carGeom;
    SoTransform *screechTransform;
    SoSeparator *annotation;

    static SoSeparator *sharedGeom;
    static SbPList roboList;
    static int robotCarNum;
};

#endif /* _ROBOT_CAR_ */


