/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef  _SKY_
#define  _SKY_

#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/nodes/SoSubNode.h>
#include <Inventor/fields/SoSFColor.h>
#include <Inventor/fields/SoSFFloat.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Sky
//
//  A Sky section of track
//
//////////////////////////////////////////////////////////////////////////////

class Sky : public SoNode
{
    SO_NODE_HEADER(Sky);

  public:
    static void		initClass();

    Sky();

    SoSFColor	horizonColor;
    SoSFFloat	horizonHeight;
    SoSFColor	skyBottomColor;
    SoSFColor	skyTopColor;

  protected:
    virtual ~Sky();

    virtual void GLRender(SoGLRenderAction *action);
    virtual SbBool      affectsState() const;

    SoRef<SoFaceSet> m_skyFaceSet;
    SoRef<SoVertexProperty> m_skyVertices;
};

#endif /* _SKY_ */


