/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/engines/SoCompose.h>
#include <Inventor/errors/SoDebugError.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>

#include "StartFinish.h"

#include <assert.h>

SO_NODE_SOURCE(StartFinish);

SoSeparator *StartFinish::sharedStuff;

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Init StartFinish class
//

void
StartFinish::initClass()

//
////////////////////////////////////////////////////////////////////////
{
    // Init parent class
    if (TrackSegment::getClassTypeId() == SoType::badType()) {
	TrackSegment::initClass();
    }
    if (Straight::getClassTypeId() == SoType::badType()) {
	Straight::initClass();
    }

    getClassRenderEngineMode().setRenderMode(SbRenderEngineMode::OIV_OPENINVENTOR_RENDERING);
    SO_NODE_INIT_CLASS(StartFinish, Straight, "Straight");
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Public constructor
//

StartFinish::StartFinish(float l) : Straight(l)

//
////////////////////////////////////////////////////////////////////////
{
    SO_NODE_CONSTRUCTOR(StartFinish);

    constructSceneGraph();
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    StartFinish constructor; called by DB when reading.
//

StartFinish::StartFinish()

//
////////////////////////////////////////////////////////////////////////
{
    SO_NODE_CONSTRUCTOR(StartFinish);
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    StartFinish destructor
//

StartFinish::~StartFinish()

//
////////////////////////////////////////////////////////////////////////
{
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Create the scene graph, based on the length field.
//

void
StartFinish::constructSceneGraph()
//
////////////////////////////////////////////////////////////////////////
{
    if (sharedStuff == NULL) {
	SoInput in;
	if (!in.openFile("$OIVHOME/examples/source/Inventor/SlotCar/data/StartFinish.iv")) {
	    fprintf(stderr, "Couldn't open $OIVHOME/examples/source/Inventor/SlotCar/data/StartFinish.iv\n");
	    sharedStuff = new SoSeparator;
	} else {
	    sharedStuff = SoDB::readAll(&in);
	    in.closeFile();
	}
    }
    transform = new SoTransform;
    transform->scaleFactor = SbVec3f(1.0, 1.0, length.getValue());
    addChild(transform);
    addChild(sharedStuff);
}


