/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef  _GAME_STATE_
#define  _GAME_STATE_

#include <Inventor/SbPList.h>
#include <Inventor/SbTime.h>
#include <Inventor/SbBox.h>
#include <Inventor/SoLists.h>
#include "Network.h"
#include "Car.h"

class SoCamera;
class SoSensor;
class SoSeparator;
class SoSwitch;
class SoSFInt32;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: GameState
//
//  This class contains all state information for the slotcar game.
//
//////////////////////////////////////////////////////////////////////////////

class GameState {
 public:

    SbTime		startTime;	// Time session was started
    SbTime		gameTime;	// Elapsed game time
    SbTime		packetTime;	// Time since last packet was sent
    SbTime		raceStartTime;  // Time race will be/was started
    float		startDelay;	// Time to wait before starting race
    int			myCarNumber;	// Number of my car
    SbBool		myCarStartedRace;// TRUE if my car started race
    Network *		network;	// The network class
    SoSeparator	*	scene;		// Scene to be rendered.
    Track *		track;		// The track
    SoCamera *		camera;		// The view
    SbVec3f		carBox[8];  	// The standard 3D extents of a car
    int			numCarsFinished;// Number of cars that have finished
    SbBool              playQuietly;	// Play audio or not
    SbBool              showAnnotation;	// Display name over cars or not
    SbString            playerName;	// This player's name
    Car *		controlledCar;	// Car controlled by mouse
    int			cameraUpDown;	// 0...20, controls camera
    int			cameraBackForth;// 0...20, controls camera
#ifdef _WIN32
    int                 numRobotCars;   // 1..8 (now created in SetupGame)
#endif

    enum Mode {
	START_SCREEN = 0,
	PRACTICING = 1,
	RACE_STARTING = 2,
	RACING = 3,
	AFTER_RACE = 4,
	RACE_OVER = 5
    };
    SoSFInt32		*mode;		// Modes global field

    SoSensor *		simulationSensor;

    GameState();
    Car *		findCar(const CarPlayer &player) const;
    Car *		getCar(int which) const { return (Car *)cars[which]; }
    Car *		getControlledCar() const { return controlledCar; }
    int			getNumCars() const { return cars.getLength(); }
    void		addCar(Car *, SbBool mine = FALSE);
    void		removeCar(Car *);
    void		sortCars();
    void		displayPlaces();
    void		displayPointTotals();

  private:
    SbPList 		cars;		// List of cars on the whole track
};

#endif /* _GAME_STATE_ */


