/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef  _STRAIGHT_
#define  _STRAIGHT_

#include "Track.h"

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Straight
//
//  A straight section of track
//
//////////////////////////////////////////////////////////////////////////////

class Straight : public TrackSegment
{
    SO_NODE_HEADER(Straight);

  public:
    static void		initClass();

    // Must pass length to constructor.
    Straight(float length);

    // This is used to link pieces together.  Called by Track.
    // This modifies lastPosition/lastOrientation.
    virtual void link(SbVec3f &lastPosition, SbRotation &lastOrientation,
		      TrackSegment *nextSeg, TrackSegment *prevSeg,
		      int trackID);

    // Given a starting position, a velocity (expressed in
    // track-length units), and a time delta, calculate a new position
    // on the track and the grip at that position.
    void getNewPosition(const TrackPosition &start,
			const TrackPosition &velocity,
			const SbTime &deltaTime,
			TrackPosition &result,
			float &grip);

    // Given a track position, return a world-space position:
    void getWorldPosition(const TrackPosition &position,
			  WorldPosition &result);

    // Given a track position, return the curvature or length at that position
    float getCurvature(const TrackPosition &position);
    float getLength(const TrackPosition &position);

  protected:
    Straight();
    virtual ~Straight();

    // Override read() to setup scene graph:
    virtual SbBool      readInstance(SoInput *in, unsigned short flags);

    // This is called by readInstance or the public constructor to
    // create an appropriate scene graph.
    virtual void	constructSceneGraph();

    // Length of track is stored as a field.  Default value of 1.0
    // corresponds to 100 world units long.
    SoSFFloat length;
    
    int			ID;
    TrackSegment *	next;
    TrackSegment *	prev;
    SbVec3f		startPosition;
    SbRotation  	orientation;
    
    SoTransform *transform;
  private:
    static SoSeparator *sharedStuff;
};

#endif /* _STRAIGHT_ */


