////////////////////////////////////////////////////////////////////////
//
// Option dialog for Win32 version of Slotcar
// (Because Win32 programs are usually not started from the command line.)
//
// Copyright (C) 1995 Template Graphics Software, Inc.
//
// Note! The radio button logic in the dialog proc *depends* on the radio
// button ids being contiguous, ascending ranges (see resource.h).

#include <windows.h>
#include "resource.h"

#include <Inventor/Win/SoWin.h>
#include "../State.h"

////////////////////////////////////////////////////////////////////////
BOOL CALLBACK optionDlgProc( HWND hwnd, UINT message,
                             WPARAM wParam, LPARAM lParam )
{
    static GameState *gameState = NULL;

    switch (message) {

    case WM_INITDIALOG:
        gameState = (GameState*)lParam;

	// Player name edit field
	SetDlgItemText( hwnd, IDC_EDIT1, gameState->playerName.getString() );

	// Player car number radio buttons
	if (gameState->myCarNumber == -1)
	    CheckRadioButton( hwnd, IDC_RADIO0, IDC_RADIO8, IDC_RADIO0 );
	else
	    CheckRadioButton( hwnd, IDC_RADIO0, IDC_RADIO8,
	                      (IDC_RADIO0 + gameState->myCarNumber) );

	// Number of robot cars radio buttons
	if (gameState->numRobotCars == 0)
	    CheckRadioButton( hwnd, IDC_RADIO10, IDC_RADIO18, IDC_RADIO10 );
	else
	    CheckRadioButton( hwnd, IDC_RADIO10, IDC_RADIO18,
	                      (IDC_RADIO10 + gameState->numRobotCars) );

	// Sound on/off check box
	CheckDlgButton( hwnd, IDC_CHECK1, !gameState->playQuietly );
        return TRUE;

    case WM_COMMAND:
        switch (LOWORD(wParam)) {

        case IDOK:
	    {
	    char buffer[256];
	    int  i, rc;

	    // Player name
	    rc = GetDlgItemText( hwnd, IDC_EDIT1, buffer, 256 );
	    if (rc)
	        gameState->playerName = buffer;

            // Player car number
	    if (IsDlgButtonChecked( hwnd, IDC_RADIO0 ))
	        gameState->myCarNumber = -1;
	    else {
	        for (i = IDC_RADIO1; i <= IDC_RADIO8; i++) {
		    if (IsDlgButtonChecked( hwnd, i )) {
		        gameState->myCarNumber = i - IDC_RADIO0;
			break;
		    }
		}
	    }

            // Number of robot cars
	    for (i = IDC_RADIO10; i <= IDC_RADIO18; i++) {
	        if (IsDlgButtonChecked( hwnd, i )) {
		    gameState->numRobotCars = i - IDC_RADIO10;
		    break;
		}
	    }

	    gameState->playQuietly = !IsDlgButtonChecked( hwnd, IDC_CHECK1 );
	    EndDialog( hwnd, 0 );
	    }
	    return TRUE;

        case IDCANCEL:
            EndDialog( hwnd, 0 );
            return TRUE;
        }
    }
    return FALSE;
}


////////////////////////////////////////////////////////////////////////
void doOptionDialog( GameState *gameState )
{
  INT_PTR rc = DialogBoxParam((Hinst)GetModuleHandle(NULL),
                           MAKEINTRESOURCE(IDD_DIALOG1),
                           SoWin::getTopLevelWidget(),
                           (DLGPROC)optionDlgProc,
                           (LPARAM)gameState);
  if (rc == (-1)) {
    //DWORD dwErr = GetLastError();
    MessageBox(SoWin::getTopLevelWidget(),
               "Win32 function DialogBoxParam failed.",
               "Error", MB_ICONEXCLAMATION | MB_OK);
  }
  return;
}


