/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

// Author: Brian Anderson 

// InlineLoader is used to load Inlines that are on the local filesystem,
// it will not fetch files over a network.  It organizes multiple
// requests so that the same subgraph is used if the filename is the same.

#ifndef  _INLINE_LOADER_
#define  _INLINE_LOADER_

class SoWWWInline;

class InlineLoader {
public:

  typedef void ReadingInlineCB(const SbString& filename, 
    void *userData, InlineLoader *);

  InlineLoader();
  ~InlineLoader();

  void  FetchAllEmpty();
  void  FetchNextFile();

  void  ClearLists();
  void  FixWWWInlines(SoNode *graph);

  void setLoadAllImmediate(SbBool onOff) {
    loadAllImmediate = onOff; };
    SbBool isLoadAllImmediate() { return loadAllImmediate; };

    void setReadingInlineCallback(ReadingInlineCB *callback,
      void *userData = NULL) {
        readingInlineCallback = callback;
        readingInlineData = userData; };

private:
  SoGroup *readFile(const SbString& filename);
  void removeTail(SoPath *p);
  void removeNodesOfType(SoNode *graph, SoType type);

  SbBool loadAllImmediate;

  int numEmptyFetch; 
  SbPList fetchQueue;
  SoOneShotSensor *sensor;

  void AddToQueue(void *data, SbVec3f size);

  static void FetchFileCB(void *userData, SoSensor *sensor);
  static void WWWInlineFetchURLCB(const SbString &url, void *userData, 
    SoWWWInline *node)
  { ((InlineLoader*)userData)->WWWInlineFetchURL(url, node); }
  void WWWInlineFetchURL(const SbString &url, SoWWWInline *node);

  // ReadingInline callback
  ReadingInlineCB  *readingInlineCallback;
  void         *readingInlineData;

};

#endif

